% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_hilfsmittel.R
\name{hilfsmittel_produktgruppe}
\alias{hilfsmittel_produktgruppe}
\title{Get Hilfsmittel product group details}
\usage{
hilfsmittel_produktgruppe(
  id,
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{id}{Produktgruppe id.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with product group details.
}
\description{
Get Hilfsmittel product group details
}
\details{
Returns details for a product group (Produktgruppe).
Official docs: https://github.com/bundesAPI/hilfsmittel-api.
}
\examples{
\dontrun{
tree <- hilfsmittel_tree(level = 1)
hilfsmittel_produktgruppe(tree$id[[1]])
}

}
