% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_configure_https}
\alias{do_configure_https}
\title{Add HTTPS to a buoyant Droplet}
\usage{
do_configure_https(
  droplet,
  domain,
  email,
  terms_of_service = FALSE,
  force = FALSE,
  ...
)
}
\arguments{
\item{droplet}{The droplet on which to act. It's expected that this droplet
was provisioned using \code{\link[=do_provision]{do_provision()}}.  See \code{\link[analogsea:droplet]{analogsea::droplet()}} to
obtain a reference to a running droplet.}

\item{domain}{The domain name associated with this instance. Used to obtain a
TLS/SSL certificate.}

\item{email}{Your email address; given to letsencrypt for "urgent renewal and
security notices".}

\item{terms_of_service}{Set to \code{TRUE} to agree to the letsencrypt subscriber
agreement. At the time of writing, the current version is available
\href{https://letsencrypt.org/documents/LE-SA-v1.2-November-15-2017.pdf}{here}.
Must be set to true to obtain a certificate through letsencrypt.}

\item{force}{If \code{FALSE}, will error if the given domain name does not appear
to be registered for this droplet according to DigitalOcean's Metadata service.
If \code{TRUE}, will ignore any discrepancy and attempt to register anyway.}

\item{...}{additional arguments to pass to \code{\link[analogsea:droplet_ssh]{analogsea::droplet_ssh()}}, such as
\code{keyfile}.}
}
\value{
The DigitalOcean droplet
}
\description{
Adds TLS/SSL (HTTPS) to a droplet created using \code{\link[=do_provision]{do_provision()}}.
}
\details{
In order to get a TLS/SSL certificate, you need to point a domain name to the
IP address associated with your droplet. If you don't already have a domain
name, you can register one on \href{https://domains.google}{Google Domains} or
\href{https://aws.amazon.com/route53/}{Amazon Route53}.

When sourcing a domain name, check if your registrar allows you to manage your own DNS
records. If not, consider a service like \href{https://www.cloudflare.com}{CloudFlare} to manage
your DNS. DigitalOcean also offers DNS management.
}
\examples{
\dontrun{
  droplet <- analogsea::droplet(123456)

  # Add HTTPS support with Let's Encrypt
  do_configure_https(
    droplet,
    domain = "myapp.example.com",
    email = "admin@example.com",
    terms_of_service = TRUE
  )
}
}
