% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activityOverlap.R
\name{activityOverlap}
\alias{activityOverlap}
\title{Plot overlapping kernel densities of two-species activities}
\usage{
activityOverlap(
  recordTable,
  speciesA,
  speciesB,
  speciesCol = "Species",
  recordDateTimeCol = "DateTimeOriginal",
  recordDateTimeFormat = "ymd HMS",
  plotR = TRUE,
  writePNG = FALSE,
  addLegend = TRUE,
  legendPosition = "topleft",
  plotDirectory,
  createDir = FALSE,
  pngMaxPix = 1000,
  add.rug = TRUE,
  overlapEstimator = c("Dhat1", "Dhat4", "Dhat5"),
  ...
)
}
\arguments{
\item{recordTable}{data.frame. the record table created by
\code{\link{recordTable}}}

\item{speciesA}{Name of species 1 (as found in \code{speciesCol} of
recordTable)}

\item{speciesB}{Name of species 2 (as found in \code{speciesCol} of
recordTable)}

\item{speciesCol}{character. name of the column specifying species names in
\code{recordTable}}

\item{recordDateTimeCol}{character. name of the column specifying date and
time in \code{recordTable}}

\item{recordDateTimeFormat}{character. format of column
\code{recordDateTimeCol} in \code{recordTable}}

\item{plotR}{logical. Show plots in R graphics device?}

\item{writePNG}{logical. Create pngs of the plots?}

\item{addLegend}{logical. Add a legend to the plots?}

\item{legendPosition}{character. Position of the legend (keyword)}

\item{plotDirectory}{character. Directory in which to create png plots if
\code{writePNG = TRUE}}

\item{createDir}{logical. Create \code{plotDirectory}?}

\item{pngMaxPix}{integer. image size of png (pixels along x-axis)}

\item{add.rug}{logical. add a rug to the plot?}

\item{overlapEstimator}{character. Which overlap estimator to return (passed
on to argument \code{type} in \code{\link[overlap]{overlapEst}})}

\item{\dots}{additional arguments to be passed to function
\code{\link[overlap]{overlapPlot}}}
}
\value{
Returns invisibly the \code{data.frame} with plot coordinates
returned by \code{\link[overlap]{overlapPlot}}.
}
\description{
This function plots kernel density estimates of two species' diel activity
data by calling the function \code{\link[overlap]{overlapPlot}} from package
\pkg{overlap}. It further computes the overlap coefficient Dhat1 by calling
\code{\link[overlap]{overlapEst}}.
}
\details{
\code{...} can be graphical parameters passed on to function
\code{\link[overlap]{overlapPlot}}, e.g. \code{linetype}, \code{linewidth},
\code{linecol} (see example below).

\code{recordDateTimeFormat} defaults to the "YYYY-MM-DD HH:MM:SS"
convention, e.g. "2014-09-30 22:59:59". \code{recordDateTimeFormat} can be
interpreted either by base-R via \code{\link[base]{strptime}} or in
\pkg{lubridate} via \code{\link[lubridate]{parse_date_time}} (argument
"orders"). \pkg{lubridate} will be used if there are no "\%" characters in
\code{recordDateTimeFormat}.

For "YYYY-MM-DD HH:MM:SS", \code{recordDateTimeFormat} would be either
"\%Y-\%m-\%d \%H:\%M:\%S" or "ymd HMS". For details on how to specify date
and time formats in R see \code{\link[base]{strptime}} or
\code{\link[lubridate]{parse_date_time}}.
}
\note{
Please be aware that the function (like the other activity... function
of this package) use clock time, not solar time. If your survey was long
enough to see changes in sunrise and sunset times, this may result in biased
representations of species activity.
}
\examples{

if(requireNamespace("overlap")) {

# load record table
data(recordTableSample)

# define species of interest
speciesA_for_activity <- "VTA"    # = Viverra tangalunga, Malay Civet
speciesB_for_activity <- "PBE"    # = Prionailurus bengalensis, Leopard Cat

# create activity overlap plot (basic)
activityOverlap (recordTable = recordTableSample,
                 speciesA    = "VTA",    # = Viverra tangalunga, Malay Civet
                 speciesB    = "PBE",    # = Prionailurus bengalensis, Leopard Cat
                 writePNG    = FALSE,
                 plotR       = TRUE
)


                                     
# create activity overlap plot (prettier and with some overlapPlot arguments set)

activityOverlap (recordTable = recordTableSample,
                 speciesA    = speciesA_for_activity,
                 speciesB    = speciesB_for_activity,
                 writePNG    = FALSE,
                 plotR       = TRUE,
                 createDir   = FALSE,
                 pngMaxPix   = 1000,
                 linecol     = c("black", "blue"),
                 linewidth   = c(5,3),
                 linetype    = c(1, 2),
                 olapcol     = "darkgrey",
                 add.rug     = TRUE,
                 extend      = "lightgrey",
                 ylim        = c(0, 0.25),
                 main        = paste("Activity overlap between ", 
                                     speciesA_for_activity, "and", 
                                     speciesB_for_activity)
)
}

}
\references{
Mike Meredith and Martin Ridout (2018). overlap: Estimates of
coefficient of overlapping for animal activity patterns. R package version
0.3.2. \url{https://CRAN.R-project.org/package=overlap} \cr Ridout, M.S. and
Linkie, M. (2009) Estimating overlap of daily activity patterns from camera
trap data. Journal of Agricultural, Biological and Environmental Statistics,
14, 322-337.
}
\seealso{
\code{\link{activityDensity}} \cr
\url{https://www.kent.ac.uk/smsas/personal/msr/overlap.html}
}
\author{
Juergen Niedballa
}
