#' Expenditure and Default Data
#' 
#' Cross-section data on the credit history for a sample of applicants for a type of credit card.
#' 
#' @format A data frame with 1319 rows and 10 variables:
#' \describe{
#'   \item{expenditure}{average monthly credit card expenditure}
#'   \item{reports}{number of major derogatory reports}
#'   \item{age}{age in years plus twelfths of a year}
#'   \item{income}{yearly income (in USD 10,000)}
#'   \item{owner}{1 if owns their home, 0 if rent}
#'   \item{selfempl}{1 if self employed, 0 if not}
#'   \item{dependents}{number of dependents}
#'   \item{months}{months living at current address}
#'   \item{majorcards}{number of major credit cards held}
#'   \item{active}{number of active credit accounts}
#' }
#' @docType data
#' @source Online complements to Greene (2003). Table F21.4.
#' <https://pages.stern.nyu.edu/~wgreene/Text/tables/tablelist5.htm>
#' @references Greene, W.H. (2003). *Econometric Analysis*, 5th edition. Upper Saddle River, NJ: Prentice Hall.
"creditcard"
