% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_reduced_rank_regression.R
\name{cca_group_rrr_cv}
\alias{cca_group_rrr_cv}
\title{Group-Sparse Canonical Correlation via Reduced-Rank Regression with CV}
\usage{
cca_group_rrr_cv(
  X,
  Y,
  groups,
  r = 2,
  lambdas = 10^seq(-3, 1.5, length.out = 10),
  kfolds = 5,
  parallelize = FALSE,
  standardize = FALSE,
  LW_Sy = TRUE,
  solver = "ADMM",
  rho = 1,
  thresh_0 = 1e-06,
  niter = 10000,
  thresh = 1e-04,
  verbose = FALSE,
  nb_cores = NULL
)
}
\arguments{
\item{X}{Predictor matrix (n x p)}

\item{Y}{Response matrix (n x q)}

\item{groups}{List of index vectors defining groups of predictors}

\item{r}{Target rank}

\item{lambdas}{Grid of regularization parameters to try out}

\item{kfolds}{Nb of folds for the CV procedure}

\item{parallelize}{Whether to use parallel processing (default is FALSE)}

\item{standardize}{Whether to scale variables}

\item{LW_Sy}{Whether to apply Ledoit-Wolf shrinkage to Sy (default TRUE)}

\item{solver}{Either "ADMM" or "CVXR"}

\item{rho}{ADMM parameter}

\item{thresh_0}{tolerance for declaring entries non-zero}

\item{niter}{Maximum number of ADMM iterations}

\item{thresh}{Convergence threshold for ADMM}

\item{verbose}{Print diagnostics}

\item{nb_cores}{Number of cores to use for parallelization (default is all available cores minus 1)}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{lambda}{Optimal regularisation parameter lambda chosen by CV}
\item{rmse}{Mean squared error of prediction (as computed in the CV)}
\item{cor}{Canonical covariances}
}
}
\description{
Performs group-sparse reduced-rank regression for CCA using either ADMM or CVXR solvers.
}
