% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_bulk.R
\name{fix_bulk}
\alias{fix_bulk}
\title{Fix in missing genes in bulk RNA-Seq matrix}
\usage{
fix_bulk(bulk, mk)
}
\arguments{
\item{bulk}{matrix of bulk RNA-Seq}

\item{mk}{object of class 'cellMarkers'. See \code{\link[=cellMarkers]{cellMarkers()}}.}
}
\value{
Expanded bulk matrix with extra rows for missing genes, filled with
zeros.
}
\description{
Fills in missing genes in a bulk RNA-Seq matrix based on the gene signature
of a 'cellMarkers' objects. Signature is taken from both the subclass gene
set and group gene set.
}
\details{
This is a convenience function if you have an existing cellMarkers signature
object and you do not want to remove genes from the existing signatures by
running \code{\link[=updateMarkers]{updateMarkers()}} with the desired bulk data, and are prepared to
accept the assumption that genes which are missing in the bulk RNA-Seq
dataset have zero expression. We recommend you check which signature genes
are missing from the bulk data first.
}
