% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censuspyrID.R
\name{pop_summary}
\alias{pop_summary}
\title{Print Population Summary Statistics}
\usage{
pop_summary(data)
}
\arguments{
\item{data}{A data frame of population data for a specific province and year,
containing at least the variables:
\code{pop} (population count),
\code{sex} (coded as 1 = male, 2 = female),
\code{age5} (5-year age groups).}
}
\value{
This function does not return an object. It prints formatted summary statistics
to the console.
}
\description{
Generate and print a formatted summary of population counts, percentages,
sex ratio, and dependency ratios from a given dataset of population data
for a specific province and year.
}
\details{
The function calculates:
\itemize{
\item Total population
\item Male and female population counts and percentages
\item Age group distribution: 0–14, 15–64, and 65+ (counts and percentages)
\item Sex ratio (males per 100 females)
\item Dependency ratios (0–14, 65+, and total dependency ratio relative to 15–64)
}

Results are printed directly to the console in a formatted table.
}
\examples{
\dontrun{
# Example: population summary for Indonesia, 2020
data_idn <- pop_data_by_year(load_pop_data(), 2020) |>
  pop_data_by_reg(0) # Indonesia
pop_summary(data_idn)
}

}
\seealso{
\code{\link[=load_pop_data]{load_pop_data()}}, \code{\link[=pop_data_by_reg]{pop_data_by_reg()}}, \code{\link[=pop_data_by_year]{pop_data_by_year()}}, \code{\link[=get_code_label]{get_code_label()}}
}
