% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaic.R
\name{mosaic}
\alias{mosaic}
\title{Create a color mosaic visualization from color proportions}
\usage{
mosaic(
  color.props,
  size = 10,
  out.path = normalizePath("~"),
  out.prefix = "charisma_mosaic",
  verbose = TRUE
)
}
\arguments{
\item{color.props}{List of color proportion objects, where each element
contains:
\itemize{
\item \code{hex}: Hex color code (e.g., "#FF0000")
\item \code{color}: Color name
\item \code{prop}: Proportion value (all proportions must sum to 1)
}}

\item{size}{Integer specifying the dimensions of the mosaic grid
(size x size). Default is 10 (resulting in a 10 x 10 = 100 cell mosaic).}

\item{out.path}{Character string specifying the directory path for saving the
output PNG file. Default is the user's home directory.}

\item{out.prefix}{Character string prefix for the output filename. Default is
\code{"charisma_mosaic"}.}

\item{verbose}{Logical. If \code{TRUE}, prints the full output path. Default
is \code{TRUE}.}
}
\value{
Character string containing the full path to the saved PNG file.
}
\description{
This function generates a randomized mosaic grid visualization representing
the proportions of different colors, useful for visually displaying color
composition in a standardized format.
}
\details{
The mosaic function creates a visual representation of color proportions by:
\enumerate{
\item Allocating grid cells proportional to each color's proportion
\item Randomly shuffling cell positions to create a mosaic pattern
\item Saving the result as a PNG file with an informative filename
}

The output filename automatically encodes the hex codes, color names, and
proportions for documentation purposes.

\figure{charisma_mosaic_example.png}
}
\examples{
# Create a mosaic from color proportions
colors <- list(
  list(hex = "#FF0000", color = "red", prop = 0.4),
  list(hex = "#00FF00", color = "green", prop = 0.3),
  list(hex = "#0000FF", color = "blue", prop = 0.3)
)
mosaic(colors, size = 10, out.path = tempdir())

}
\seealso{
\code{\link{charisma}} for generating color classifications
}
