% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surf_area.R
\name{surf_area}
\alias{surf_area}
\title{Surface area calculation}
\usage{
surf_area(surf, by = c("vertex", "face"))
}
\arguments{
\item{surf}{The \code{"surf"} object.}

\item{by}{\code{"vertex"} or \code{"face"}. For \code{"vertex"}, the result
is the area associated with each vertex: the sum the area of each triangular
face it is a part of, divided by three. For \code{"face"}, the result is
the surface area of each face.}
}
\value{
Vector of surface areas \code{by} vertex or face, in the same order
as how the vertices or faces are listed in \code{surf}. The units are the
square of the units of \code{surf$vertices}.
}
\description{
Calculate surface area of a \code{"surf"} object by vertex or face. Surface
area calculation by vertex matches the Workbench command
"-surface-vertex-areas".
}
\seealso{
Other surface-related: 
\code{\link{add_surf}()},
\code{\link{boundary_mask_surf}()},
\code{\link{edit_mask_surf}()},
\code{\link{even_vert_samp}()},
\code{\link{is.surf}()},
\code{\link{load_surf}()},
\code{\link{mask_surf}()},
\code{\link{read_surf}()},
\code{\link{resample_surf}()},
\code{\link{rotate_surf}()},
\code{\link{view_surf}()},
\code{\link{write_surf_gifti}()}
}
\concept{surface-related}
