\name{acr_eular_gout_2015}
\alias{acr_eular_gout_2015}
\title{
2015 ACR/EULAR Gout Classification Criteria
}
\description{
Calculates the score for the 2015 ACR/EULAR Gout Classification Criteria. These criteria apply to patients with at least one episode of peripheral joint/bursa swelling, pain, or tenderness (Entry Criterion). The presence of MSU crystals is sufficient for diagnosis. If MSU crystals are not confirmed, a scoring system based on clinical, laboratory, and imaging features is used.
}
\usage{
acr_eular_gout_2015(entry_criteria, sufficient_criteria, joint_pattern,
                    symptom_characteristics, episode_time_course, clinical_tophus,
                    serum_urate, synovial_fluid_negative, imaging_urate,
                    imaging_erosion)
}
\arguments{
  \item{entry_criteria}{
Numeric (0 or 1). Has the patient had at least one episode of swelling, pain, or tenderness in a peripheral joint or bursa? (1 = Yes, 0 = No).
}
  \item{sufficient_criteria}{
Numeric (0 or 1). Presence of MSU crystals in a symptomatic joint, bursa, or tophus. (1 = Yes, 0 = No).
}
  \item{joint_pattern}{
Numeric. Pattern of joint involvement.
0: Other pattern.
1: Ankle or midfoot (mono- or oligoarticular involvement without 1st MTP).
2: 1st MTP (mono- or oligoarticular involvement).
}
  \item{symptom_characteristics}{
Numeric (0-3). Count of characteristics present during an episode: 1) Erythema overlying joint, 2) Can't bear touch/pressure, 3) Great difficulty walking or inability to use joint.
}
  \item{episode_time_course}{
Numeric. Presence of typical episodes (Time to maximal pain <24h, Resolution <=14 days, Complete resolution between episodes).
0: None.
1: One typical episode.
2: Recurrent typical episodes.
}
  \item{clinical_tophus}{
Numeric (0 or 1). Presence of draining or chalk-like subcutaneous nodule under transparent skin. (1 = Yes, 0 = No).
}
  \item{serum_urate}{
Numeric. Serum urate level in mg/dL.
Scores: <4 mg/dL (-4), 4-<6 (0), 6-<8 (+2), 8-<10 (+3), >=10 (+4).
}
  \item{synovial_fluid_negative}{
Numeric (0 or 1). Synovial fluid study was performed and was negative for MSU. (1 = Yes/Negative, 0 = Not done).
}
  \item{imaging_urate}{
Numeric (0 or 1). Evidence of urate deposition via DECT or Ultrasound (Double Contour Sign). (1 = Yes, 0 = No).
}
  \item{imaging_erosion}{
Numeric (0 or 1). Evidence of gout-related erosion on X-ray of hands/feet. (1 = Yes, 0 = No).
}
}
\value{
A list containing:
\item{Classification}{"Classified as Gout", "Not Classified as Gout", or "Not Classified" (if entry not met).}
\item{Total_Score}{The calculated score (if sufficient criteria not met).}
\item{Interpretation}{Clinical interpretation of the score.}
}
\references{
Neogi T, Jansen TL, Dalbeth N, et al. 2015 Gout classification criteria: an American College of Rheumatology/European League Against Rheumatism collaborative initiative. Ann Rheum Dis. 2015;74(10):1789-1798. doi:10.1136/annrheumdis-2015-208237
}
\examples{

# Example 1: Classic Gout Presentation
# 1st MTP (2), 3 Characteristics (3), Recurrent episodes (2), Urate 9.0 (3)
# Score = 2 + 3 + 2 + 3 = 10 -> Classified as Gout
acr_eular_gout_2015(1, 0, 2, 3, 2, 0, 9.0, 0, 0, 0)

# Example 2: Negative Workup
# Ankle (1), 1 Characteristic (1), One episode (1), Urate 5.0 (0)
# Score = 1 + 1 + 1 + 0 = 3 -> Not Classified
acr_eular_gout_2015(1, 0, 1, 1, 1, 0, 5.0, 0, 0, 0)
}
