\name{acute_gout_diagnosis}
\alias{acute_gout_diagnosis}
\title{
Acute Gout Diagnosis Rule (Janssens Rule)
}
\description{
Calculates the Acute Gout Diagnosis Rule score to estimate the probability of gout in primary care patients presenting with acute arthritis. This rule is particularly useful when synovial fluid analysis is not immediately available. It categorizes patients into Low, Intermediate, or High probability groups based on clinical and laboratory features.
}
\usage{
acute_gout_diagnosis(sex, prev_attack, onset_1day, joint_redness,
                     mtp1_involvement, htn_cvd, uric_acid_elevated)
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Male sex adds +2 points).
}
  \item{prev_attack}{
Numeric (0 or 1). Patient-reported previous arthritis attack. (1 = Yes, +2 points).
}
  \item{onset_1day}{
Numeric (0 or 1). Onset of symptoms within 1 day (maximal pain <24 hours). (1 = Yes, +0.5 points).
}
  \item{joint_redness}{
Numeric (0 or 1). Observed joint redness. (1 = Yes, +1 point).
}
  \item{mtp1_involvement}{
Numeric (0 or 1). Involvement of the 1st metatarsophalangeal (MTP1) joint. (1 = Yes, +2.5 points).
}
  \item{htn_cvd}{
Numeric (0 or 1). Presence of Hypertension or >= 1 Cardiovascular Disease (Angina, MI, Heart Failure, CVA, TIA, or PVD). (1 = Yes, +1.5 points).
}
  \item{uric_acid_elevated}{
Numeric (0 or 1). Serum Uric Acid > 5.88 mg/dL (> 0.35 mmol/L). (1 = Yes, +3.5 points).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated score (Range 0-13).}
\item{Probability}{Estimated probability of gout (<2.2\%, ~31\%, or >80\%).}
\item{Recommendation}{Diagnostic guidance (Rule out, Test Fluid, or Treat).}
}
\references{
Janssens HJ, Fransen J, van de Lisdonk EH, et al. A diagnostic rule for acute gouty arthritis in primary care without joint fluid analysis. Arch Intern Med. 2010;170(13):1120-1126. doi:10.1001/archinternmed.2010.196
}
\examples{

# Example 1: High Probability
# Male, Previous Attack, Rapid Onset, MTP1, HTN, High Uric Acid
# Score = 2 + 2 + 0.5 + 2.5 + 1.5 + 3.5 = 12
acute_gout_diagnosis("male", 1, 1, 0, 1, 1, 1)

# Example 2: Low Probability
# Female, Rapid Onset, Redness, No other features
# Score = 0.5 + 1 = 1.5
acute_gout_diagnosis("female", 0, 1, 1, 0, 0, 0)
}
