\name{adhere_algorithm}
\alias{adhere_algorithm}
\title{
ADHERE Algorithm for Acute Decompensated Heart Failure
}
\description{
Implements the classification regression tree (CART) analysis from the Acute Decompensated Heart Failure National Registry (ADHERE). This algorithm uses admission Blood Urea Nitrogen (BUN), Systolic Blood Pressure (SBP), and Serum Creatinine to stratify patients into four risk groups for in-hospital mortality.
}
\usage{
adhere_algorithm(bun, sbp, creatinine)
}
\arguments{
  \item{bun}{
Numeric. Blood Urea Nitrogen in mg/dL. (The first splitting node is at 43 mg/dL).
}
  \item{sbp}{
Numeric. Systolic Blood Pressure in mmHg. (The second splitting node is at 115 mmHg).
}
  \item{creatinine}{
Numeric. Serum Creatinine in mg/dL. (The third splitting node is at 2.75 mg/dL).
}
}
\value{
A list containing:
\item{Risk_Group}{The risk classification (Low, Intermediate, High, or Very High).}
\item{In_Hospital_Mortality_Risk}{The estimated in-hospital mortality percentage associated with the specific node in the validation set.}
}
\references{
Fonarow GC, Adams KF Jr, Abraham WT, et al. Risk stratification for in-hospital mortality in acutely decompensated heart failure: classification and regression tree analysis. JAMA. 2005;293(5):572-580. doi:10.1001/jama.293.5.572
}
\examples{

# Example 1: Low Risk (BUN < 43)
adhere_algorithm(bun = 30, sbp = 120, creatinine = 1.0)

# Example 2: Very High Risk (BUN >= 43, SBP < 115, Cr >= 2.75)
adhere_algorithm(bun = 50, sbp = 100, creatinine = 3.0)
}
