\name{aldrete_score}
\alias{aldrete_score}
\title{
Modified Aldrete Score for PACU Discharge
}
\description{
Calculates the Modified Aldrete Score, a tool used to assess a patient's recovery from anesthesia and determine readiness for discharge from the Post-Anesthesia Care Unit (PACU). The modified version replaces the original "Color" component with "Oxygen Saturation".
}
\usage{
aldrete_score(activity, respiration, circulation, consciousness, oxygenation)
}
\arguments{
  \item{activity}{
Numeric (0-2).
2: Able to move 4 extremities voluntarily or on command.
1: Able to move 2 extremities voluntarily or on command.
0: Able to move 0 extremities voluntarily or on command.
}
  \item{respiration}{
Numeric (0-2).
2: Able to breathe deeply and cough freely.
1: Dyspnea or limited breathing.
0: Apneic.
}
  \item{circulation}{
Numeric (0-2). Systemic Blood Pressure (BP) relative to pre-anesthetic level.
2: BP +/- 20 mmHg of pre-anesthetic level.
1: BP +/- 20-50 mmHg of pre-anesthetic level.
0: BP +/- >50 mmHg of pre-anesthetic level.
}
  \item{consciousness}{
Numeric (0-2).
2: Fully awake.
1: Arousable on calling.
0: Not responding.
}
  \item{oxygenation}{
Numeric (0-2). (Modified Aldrete component).
2: SpO2 > 92\% on room air.
1: SpO2 > 90\% with supplemental oxygen.
0: SpO2 < 90\% with supplemental oxygen.
}
}
\value{
A list containing:
\item{Total_Score}{The sum of the 5 components (Range 0-10).}
\item{Interpretation}{Discharge readiness (Score >= 9 usually required).}
}
\references{
Aldrete JA. The post-anesthesia recovery score revisited. J Clin Anesth. 1995;7(1):89-91. doi:10.1016/0952-8180(94)00001-s
}
\examples{

# Example 1: Ready for Discharge
# Moves 4 limbs (2), Deep breathing (2), BP within 20 (2), Awake (2), SpO2 >92\% RA (2)
aldrete_score(2, 2, 2, 2, 2)

# Example 2: Not Ready
# Moves 2 limbs (1), Dyspneic (1), BP within 20 (2), Arousable (1), SpO2 >90\% on O2 (1)
# Total = 6
aldrete_score(1, 1, 2, 1, 1)
}
