\name{charlson_comorbidity_index}
\alias{charlson_comorbidity_index}
\title{
Charlson Comorbidity Index (CCI)
}
\description{
Calculates the age-adjusted Charlson Comorbidity Index (CCI). This score predicts the 10-year survival for a patient who may have a range of comorbid conditions, such as heart disease, AIDS, or cancer (a total of 22 conditions). Each condition is assigned a score of 1, 2, 3, or 6, depending on the risk of dying associated with each one.
}
\usage{
charlson_comorbidity_index(age, myocardial_infarction, chf, pvd, cva_tia,
                           dementia, copd, connective_tissue_disease,
                           peptic_ulcer_disease, liver_disease, diabetes,
                           hemiplegia, renal_disease, solid_tumor, leukemia,
                           lymphoma, aids)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
< 50: 0 pts.
50-59: 1 pt.
60-69: 2 pts.
70-79: 3 pts.
>= 80: 4 pts.
}
  \item{myocardial_infarction}{
Numeric (0 or 1). History of Myocardial Infarction. (1 = Yes, +1 pt).
}
  \item{chf}{
Numeric (0 or 1). Congestive Heart Failure. (1 = Yes, +1 pt).
}
  \item{pvd}{
Numeric (0 or 1). Peripheral Vascular Disease. (1 = Yes, +1 pt).
}
  \item{cva_tia}{
Numeric (0 or 1). Cerebrovascular Accident or TIA. (1 = Yes, +1 pt).
}
  \item{dementia}{
Numeric (0 or 1). Dementia. (1 = Yes, +1 pt).
}
  \item{copd}{
Numeric (0 or 1). Chronic Obstructive Pulmonary Disease. (1 = Yes, +1 pt).
}
  \item{connective_tissue_disease}{
Numeric (0 or 1). Connective Tissue Disease. (1 = Yes, +1 pt).
}
  \item{peptic_ulcer_disease}{
Numeric (0 or 1). Peptic Ulcer Disease. (1 = Yes, +1 pt).
}
  \item{liver_disease}{
String. "none" (0 pts), "mild" (Chronic Hepatitis, Cirrhosis without portal hypertension: +1 pt), or "moderate_severe" (Cirrhosis with portal hypertension, variceal bleeding: +3 pts).
}
  \item{diabetes}{
String. "none" (0 pts), "uncomplicated" (Diet-controlled or meds: +1 pt), or "end_organ_damage" (Retinopathy, Neuropathy, Nephropathy: +2 pts).
}
  \item{hemiplegia}{
Numeric (0 or 1). Hemiplegia. (1 = Yes, +2 pts).
}
  \item{renal_disease}{
Numeric (0 or 1). Moderate to Severe Chronic Kidney Disease. (1 = Yes, +2 pts).
}
  \item{solid_tumor}{
String. "none" (0 pts), "localized" (Localized solid tumor: +2 pts), or "metastatic" (Metastatic solid tumor: +6 pts).
}
  \item{leukemia}{
Numeric (0 or 1). Leukemia. (1 = Yes, +2 pts).
}
  \item{lymphoma}{
Numeric (0 or 1). Lymphoma. (1 = Yes, +2 pts).
}
  \item{aids}{
Numeric (0 or 1). AIDS. (1 = Yes, +6 pts).
}
}
\value{
A list containing:
\item{CCI_Score}{The total calculated Charlson Comorbidity Index.}
\item{Estimated_10_Year_Survival}{Estimated percentage survival over 10 years.}
}
\references{
Charlson ME, Pompei P, Ales KL, MacKenzie CR. A new method of classifying prognostic comorbidity in longitudinal studies: development and validation. J Chronic Dis. 1987;40(5):373-383. doi:10.1016/0021-9681(87)90171-8
}
\examples{

# Example 1: High Risk
# 75yo (+3), Diabetes w/ End Organ Damage (+2), CHF (+1), MI (+1)
# Score = 7
charlson_comorbidity_index(75, 1, 1, 0, 0, 0, 0, 0, 0,
"none", "end_organ_damage", 0, 0, "none", 0, 0, 0)

# Example 2: Low Risk
# 45yo (0), Uncomplicated Diabetes (+1)
# Score = 1
charlson_comorbidity_index(45, 0, 0, 0, 0, 0, 0, 0, 0,
"none", "uncomplicated", 0, 0, "none", 0, 0, 0)
}
