\name{cows_opiate_withdrawal}
\alias{cows_opiate_withdrawal}
\title{
Clinical Opiate Withdrawal Scale (COWS)
}
\description{
Calculates the COWS score, an 11-item clinician-administered scale used to assess the severity of opiate withdrawal and monitor the response to treatment (e.g., buprenorphine induction). The score determines the level of physical dependence and withdrawal severity.
}
\usage{
cows_opiate_withdrawal(pulse_score, sweating_score, restlessness_score,
                       pupil_size_score, bone_joint_ache_score,
                       runny_nose_tearing_score, gi_upset_score, tremor_score,
                       yawning_score, anxiety_irritability_score, gooseflesh_score)
}
\arguments{
  \item{pulse_score}{
Numeric. Score for Resting Pulse Rate. (0: <80, 1: 81-100, 2: 101-120, 4: >120).
}
  \item{sweating_score}{
Numeric. Score for Sweating. (0: None, 1: Subjective chills/flushing, 2: Flushed/moist face, 3: Beads of sweat, 4: Drenching sweat).
}
  \item{restlessness_score}{
Numeric. Score for Restlessness. (0: Able to sit still, 1: Difficulty sitting still, 3: Moving legs/arms often, 5: Unable to sit still).
}
  \item{pupil_size_score}{
Numeric. Score for Pupil Size. (0: Normal/Constricted, 1: Normal/Slightly large, 2: Moderate dilation, 5: Severe dilation).
}
  \item{bone_joint_ache_score}{
Numeric. Score for Bone/Joint Aches. (0: None, 1: Mild diffuse discomfort, 2: Severe aches/rubbing joints, 4: Rubbing joints/unable to sit still due to pain).
}
  \item{runny_nose_tearing_score}{
Numeric. Score for Runny Nose/Tearing. (0: None, 1: Stuffy nose/moist eyes, 2: Dripping nose/tearing, 4: Constant running/streaming).
}
  \item{gi_upset_score}{
Numeric. Score for GI Upset. (0: None, 1: Cramps, 2: Nausea/loose stool, 3: Vomiting/Diarrhea, 5: Multiple vomiting/diarrhea).
}
  \item{tremor_score}{
Numeric. Score for Tremor. (0: None, 1: Not visible/can be felt, 2: Visible/mild, 4: Gross/muscle twitching).
}
  \item{yawning_score}{
Numeric. Score for Yawning. (0: None, 1: 1-2 times, 2: Several times, 4: Frequent/several per minute).
}
  \item{anxiety_irritability_score}{
Numeric. Score for Anxiety/Irritability. (0: None, 1: Increasing irritability, 2: Obviously irritable/anxious, 4: Severe anxiety/mania).
}
  \item{gooseflesh_score}{
Numeric. Score for Gooseflesh skin. (0: None, 3: Pilnoerection perceptible to touch, 5: Prominent piloerection).
}
}
\value{
A list containing:
\item{COWS_Score}{The calculated total score (Range 0-48).}
\item{Severity_Category}{Interpretation: Mild (5-12), Moderate (13-24), Moderately Severe (25-36), Severe (>36).}
}
\references{
Wesson DR, Ling W. The Clinical Opiate Withdrawal Scale (COWS). J Psychoactive Drugs. 2003;35(2):253-259. doi:10.1080/02791072.2003.10400007
}
\examples{

# Example 1: Moderate Withdrawal
# Pulse 105 (+2), Sweating (+2), Restless (+1), Aches (+1), GI (+2), Anxiety (+2), Others 0
# Total = 10 (Wait, sum is 10, which is Mild. Let's add Tremor +2, Yawning +1 -> Total 13)
cows_opiate_withdrawal(2, 2, 1, 0, 1, 0, 2, 2, 1, 2, 0)

# Example 2: Severe Withdrawal
# Pulse >120 (+4), Drenching Sweat (+4), Severe Restlessness (+5),
# Dilated Pupils (+5), Severe Aches (+4), Vomiting (+5), Tremor (+4),
# Frequent Yawning (+4), Severe Anxiety (+4), Gooseflesh (+5), Runny Nose (+4)
# Total = 48
cows_opiate_withdrawal(4, 4, 5, 5, 4, 4, 5, 4, 4, 4, 5)
}
