\name{crb65_pneumonia_severity}
\alias{crb65_pneumonia_severity}
\title{
CRB-65 Score for Pneumonia Severity
}
\description{
Calculates the CRB-65 score to stratify the severity of community-acquired pneumonia (CAP). Unlike the CURB-65 score, CRB-65 does not require blood urea nitrogen (BUN) measurement, making it suitable for use in primary care or settings without immediate laboratory access.
}
\usage{
crb65_pneumonia_severity(confusion, respiratory_rate, systolic_bp,
                         diastolic_bp, age)
}
\arguments{
  \item{confusion}{
Numeric (0 or 1). Recent confusion. (1 = Yes, +1 point).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (>= 30 bpm adds +1 point).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg. (< 90 mmHg contributes to the BP criterion).
}
  \item{diastolic_bp}{
Numeric. Diastolic blood pressure in mmHg. (<= 60 mmHg contributes to the BP criterion).
Note: The BP criterion is met if SBP < 90 OR DBP <= 60 (+1 point).
}
  \item{age}{
Numeric. Patient age in years. (>= 65 years adds +1 point).
}
}
\value{
A list containing:
\item{CRB65_Score}{The calculated score (Range 0-4).}
\item{Risk_Level}{Classification (Very Low, Increased, High).}
\item{Est_Mortality_30_Day}{Estimated mortality percentage.}
\item{Recommendation}{Guidance on disposition (Home vs. Hospital).}
}
\references{
Lim WS, van der Eerden MM, Laing R, et al. Defining community acquired pneumonia severity on presentation to hospital: an international derivation and validation study. Thorax. 2003;58(5):377-382. doi:10.1136/thorax.58.5.377
}
\examples{

# Example 1: High Risk
# 70yo (+1), Confused (+1), RR 32 (+1), BP 100/70 (0)
# Score = 3
crb65_pneumonia_severity(1, 32, 100, 70, 70)

# Example 2: Low Risk
# 40yo (0), Not confused (0), RR 18 (0), BP 120/80 (0)
# Score = 0
crb65_pneumonia_severity(0, 18, 120, 80, 40)
}
