\name{egsys_syncope_score}
\alias{egsys_syncope_score}
\title{
EGSYS Score for Cardiac Syncope
}
\description{
Calculates the EGSYS (Evaluation of Guidelines in Syncope Study) Score to stratify patients with syncope. This score helps differentiate between cardiac syncope (higher mortality risk) and neurally mediated/reflex syncope. A score of 3 or higher suggests a cardiac etiology.
}
\usage{
egsys_syncope_score(palpitations, abnormal_ecg_or_heart_disease,
                    effort_syncope, supine_syncope, autonomic_prodrome,
                    predisposing_factors)
}
\arguments{
  \item{palpitations}{
Numeric (0 or 1). Palpitations preceding the syncopal event. (1 = Yes, +4 points).
}
  \item{abnormal_ecg_or_heart_disease}{
Numeric (0 or 1). Abnormal ECG and/or history of structural heart disease. (1 = Yes, +3 points).
}
  \item{effort_syncope}{
Numeric (0 or 1). Syncope occurred during effort/exertion. (1 = Yes, +3 points).
}
  \item{supine_syncope}{
Numeric (0 or 1). Syncope occurred while supine. (1 = Yes, +2 points).
}
  \item{autonomic_prodrome}{
Numeric (0 or 1). Presence of autonomic prodrome (e.g., nausea, vomiting). (1 = Yes, -1 point).
}
  \item{predisposing_factors}{
Numeric (0 or 1). Presence of predisposing factors (e.g., warm crowded place, prolonged standing, fear/pain/emotion). (1 = Yes, -1 point).
}
}
\value{
A list containing:
\item{EGSYS_Score}{The calculated total score (Range -2 to 12).}
\item{Interpretation}{Risk stratification regarding cardiac vs. non-cardiac cause.}
\item{Likely_Etiology}{"Likely Cardiac Syncope" (Score >= 3) or "Likely Neurally Mediated Syncope" (Score < 3).}
}
\references{
Del Rosso A, Ungar A, Maggi R, et al. Clinical predictors of cardiac syncope at initial evaluation in patients referred urgently to a general hospital: the EGSYS Score. Heart. 2008;94(12):1620-1626. doi:10.1136/hrt.2008.143149
}
\examples{

# Example 1: High Risk (Cardiac)
# Palpitations (+4), Heart Disease (+3), No prodrome
# Score = 7
egsys_syncope_score(1, 1, 0, 0, 0, 0)

# Example 2: Low Risk (Neurally Mediated)
# Warm crowded room (-1), Nausea (-1), No cardiac features
# Score = -2
egsys_syncope_score(0, 0, 0, 0, 1, 1)
}
