\name{em_coding_2023}
\alias{em_coding_2023}
\title{
2023 Emergency Medicine Coding Guide (CPT 99281-99285)
}
\description{
Calculates the appropriate CPT Evaluation and Management (E/M) code for Emergency Department visits based on the 2023 AMA CPT guidelines. The selection is driven entirely by Medical Decision Making (MDM), which comprises three components:
1. Number and Complexity of Problems Addressed (COPA).
2. Risk of Complications and/or Morbidity or Mortality of Patient Management.
3. Amount and/or Complexity of Data to be Reviewed and Analyzed.

The final code is determined by the "2 out of 3" rule: the code corresponds to the MDM level met or exceeded by at least two of the three components.
}
\usage{
em_coding_2023(problem_complexity, risk_level, tests_ordered = 0, tests_reviewed = 0,
               prior_notes_reviewed = 0, independent_historian = 0,
               independent_interpretation = 0, discussion_management = 0)
}
\arguments{
  \item{problem_complexity}{
String. Description of the patient's problem complexity. Matches MDCalc categories (e.g., "chronic illness w/severe exacerbation", "1 acute uncomplicated illness", "2 minor problems"). The function performs keyword matching to identify the severity level (Minimal, Low, Moderate, High).
}
  \item{risk_level}{
String. The risk level of patient management decisions. Accepted values: "High", "Moderate", "Low", "Minimal".
}
  \item{tests_ordered}{
Numeric (0, 1, 2, or 3). Number of unique tests ordered (e.g., Labs, CT, EKG). Input 3 if >= 3.
}
  \item{tests_reviewed}{
Numeric (0, 1, 2, or 3). Number of unique test results reviewed. Input 3 if >= 3.
}
  \item{prior_notes_reviewed}{
Numeric (0, 1, 2, or 3). Number of unique prior external notes reviewed. Input 3 if >= 3.
}
  \item{independent_historian}{
Numeric (0 or 1). Was an independent historian (e.g., parent, EMS, spouse) required? 1 = Yes, 0 = No.
}
  \item{independent_interpretation}{
Numeric (0 or 1). Did the provider perform an independent interpretation of a test (not separately billed)? 1 = Yes, 0 = No.
}
  \item{discussion_management}{
Numeric (0 or 1). Was there discussion of management or test interpretation with an external physician or qualified healthcare professional? 1 = Yes, 0 = No.
}
}
\value{
A list containing:
\item{CPT_Code}{The calculated CPT code (99282, 99283, 99284, or 99285).}
\item{MDM_Level}{The overall Medical Decision Making level (Straightforward, Low, Moderate, High).}
\item{Component_Scores}{The calculated level for each individual component (COPA, Risk, Data).}
\item{Data_Breakdown}{Internal counts used to determine the Data complexity level.}
}
\references{
American Medical Association. CPT® Evaluation and Management (E/M) Code and Guideline Changes. 2023.
ACEP. 2023 Emergency Department Evaluation and Management Guidelines.
}
\examples{

# Example 1: 99285 (High Complexity)
# Severe exacerbation (High COPA), Prescription management (Moderate Risk),
# but Extensive Data (3 tests + Independent Historian + Discussion)
em_coding_2023(
  problem_complexity = "chronic illness w/severe exacerbation",
  risk_level = "Moderate",
  tests_ordered = 3,
  independent_historian = 1,
  discussion_management = 1
)

# Example 2: 99284 (Moderate Complexity)
# Acute systemic illness (Moderate COPA), Prescription drug (Moderate Risk),
# Minimal Data
em_coding_2023(
  problem_complexity = "acute illness w/systemic sx",
  risk_level = "Moderate",
  tests_ordered = 1
)
}
