\name{estimated_peak_flow}
\alias{estimated_peak_flow}
\title{
Estimated/Expected Peak Expiratory Flow (Peak Flow) - NHANES III
}
\description{
Calculates the estimated Peak Expiratory Flow (PEF) rate based on the Hankinson et al. (1999) equations derived from the Third National Health and Nutrition Examination Survey (NHANES III). These equations stratify by age, sex, and race/ethnicity (Caucasian, African-American, Mexican-American) and use height and age polynomial regression models.
}
\usage{
estimated_peak_flow(age, height_in, sex, race, actual_pef = NULL)
}
\arguments{
  \item{age}{
Numeric. Patient age in years (Valid range: 8-80).
}
  \item{height_in}{
Numeric. Patient height in inches.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{race}{
String. Patient race/ethnicity ("White", "Black", "Hispanic", or "Other"). "Other" uses the Caucasian/White equation coefficients.
}
  \item{actual_pef}{
Numeric (Optional). The patient's actual measured PEF in L/min. If provided, the function calculates the percent of predicted value.
}
}
\value{
A list containing:
\item{Estimated_PEF_L_min}{The predicted Peak Expiratory Flow rate in Liters per minute.}
\item{Percent_Predicted}{The ratio of the actual measured PEF to the estimated PEF (if actual_pef is provided).}
\item{Method}{Citation of the formula source (Hankinson 1999).}
}
\references{
Hankinson JL, Odencrantz JR, Fedan KB. Spirometric reference values from a sample of the general U.S. population. Am J Respir Crit Care Med. 1999;159(1):179-187. doi:10.1164/ajrccm.159.1.9712108
}
\examples{

# Example 1: Adult Male
# 45 years old, 70 inches (178 cm), White
# Estimated PEF: ~580-600 L/min depending on exact coeff
estimated_peak_flow(45, 70, "male", "white")

# Example 2: Child with Actual Reading
# 10 years old, 55 inches (140 cm), Black, Measured PEF 300
# Returns Estimated and % Predicted
estimated_peak_flow(10, 55, "male", "black", actual_pef = 300)
}
