\name{euromacs_rhf_score}
\alias{euromacs_rhf_score}
\title{
EUROMACS Right Heart Failure (RHF) Risk Score
}
\description{
Calculates the EUROMACS RHF Score to predict the risk of early right heart failure following Left Ventricular Assist Device (LVAD) implantation. This scoring system was derived from the European Registry for Patients with Mechanical Circulatory Support (EUROMACS).
}
\usage{
euromacs_rhf_score(cvp_pcwp_ratio_gt_054, multiple_inotropes,
                   severe_rv_dysfunction, intermacs_1_2, hemoglobin_le_10)
}
\arguments{
  \item{cvp_pcwp_ratio_gt_054}{
Numeric (0 or 1). Is the ratio of Right Atrial Pressure (CVP) to Pulmonary Capillary Wedge Pressure (PCWP) > 0.54? (1 = Yes, +2 points).
}
  \item{multiple_inotropes}{
Numeric (0 or 1). Requirement for >= 2 inotropes? (1 = Yes, +2.5 points).
}
  \item{severe_rv_dysfunction}{
Numeric (0 or 1). Presence of severe Right Ventricular (RV) dysfunction on echocardiography (TAPSE < 14mm or subjective assessment). (1 = Yes, +2 points).
}
  \item{intermacs_1_2}{
Numeric (0 or 1). INTERMACS Profile 1 ("Crash and Burn") or 2 ("Sliding on Inotropes"). (1 = Yes, +2 points).
}
  \item{hemoglobin_le_10}{
Numeric (0 or 1). Hemoglobin <= 10 g/dL (<= 100 g/L). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{EUROMACS_Score}{The calculated risk score (Range 0-9.5).}
\item{Risk_Category}{Classification (Low 0-2, Intermediate 2.5-4, High >4).}
\item{Early_RHF_Risk}{Estimated percentage risk of early RHF.}
}
\references{
Soliman OI, Akin S, Muslem R, et al. Derivation and validation of a novel right heart failure prediction score for patients undergoing left ventricular assist device implantation: the EUROMACS (European Registry for Patients with Mechanical Circulatory Support) Right Heart Failure Risk Score. Eur J Cardiothorac Surg. 2018;53(4):847-855. doi:10.1093/ejcts/ezx320
}
\examples{

# Example 1: High Risk
# Ratio > 0.54 (+2), Severe RVD (+2), Multiple Inotropes (+2.5)
# Score = 6.5
euromacs_rhf_score(1, 1, 1, 0, 0)

# Example 2: Low Risk
# Hemoglobin 9.5 (+1), no other factors
# Score = 1
euromacs_rhf_score(0, 0, 0, 0, 1)
}
