\name{gcs_pupils_score}
\alias{gcs_pupils_score}
\title{
GCS-Pupils (GCS-P) Score
}
\description{
Calculates the GCS-P score, which combines the standard Glasgow Coma Scale (GCS) with an assessment of pupil reactivity. This score extends the range of injury severity assessment, particularly for patients with severe TBI (GCS 3), by subtracting points for unreactive pupils. The score ranges from 1 to 15.
}
\usage{
gcs_pupils_score(gcs_total, pupils_unreactive_count)
}
\arguments{
  \item{gcs_total}{
Numeric (3-15). The standard total Glasgow Coma Scale score (Eye + Verbal + Motor).
}
  \item{pupils_unreactive_count}{
Numeric (0, 1, or 2). The number of pupils unreactive to light.
0: Both pupils reactive (Score adjustment: 0).
1: One pupil unreactive (Score adjustment: -1).
2: Both pupils unreactive (Score adjustment: -2).
}
}
\value{
A list containing:
\item{GCS_P_Score}{The calculated GCS-P score (Range 1-15).}
\item{Interpretation}{General mortality risk trend associated with the score.}
}
\references{
Brennan PM, Murray GD, Teasdale GM. Simplifying the use of prognostic information in traumatic brain injury. Part 1: The GCS-Pupils score: an extended index of clinical severity. J Neurosurg. 2018;128(6):1612-1620. doi:10.3171/2017.12.JNS172780
}
\examples{

# Example 1: Severe TBI with blown pupils
# GCS 3, 2 unreactive pupils
# Score = 3 - 2 = 1
gcs_pupils_score(3, 2)

# Example 2: Moderate TBI
# GCS 10, Reactive pupils
# Score = 10 - 0 = 10
gcs_pupils_score(10, 0)
}
