\name{h2fpef_score}
\alias{h2fpef_score}
\title{
H2FPEF Score for HFpEF Probability
}
\description{
Calculates the H2FPEF score to estimate the probability of Heart Failure with Preserved Ejection Fraction (HFpEF) in patients with unexplained dyspnea. The score uses six clinical and echocardiographic variables: Heavy (BMI > 30), Hypertensive (>= 2 meds), Atrial Fibrillation, Pulmonary Hypertension, Elder (> 60), and Filling Pressure (E/e' > 9).
}
\usage{
h2fpef_score(bmi, num_hypertensive_meds, atrial_fibrillation,
             pulmonary_hypertension_gt_35, age_gt_60, e_e_prime_gt_9)
}
\arguments{
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2). (>30 adds 2 points).
}
  \item{num_hypertensive_meds}{
Numeric. Number of antihypertensive medications currently prescribed. (>= 2 adds 1 point).
}
  \item{atrial_fibrillation}{
Numeric (0 or 1). History or presence of Paroxysmal or Persistent Atrial Fibrillation. (1 = Yes, +3 points).
}
  \item{pulmonary_hypertension_gt_35}{
Numeric (0 or 1). Pulmonary Artery Systolic Pressure > 35 mmHg on echocardiogram. (1 = Yes, +1 point).
}
  \item{age_gt_60}{
Numeric (0 or 1). Age > 60 years. (1 = Yes, +1 point).
}
  \item{e_e_prime_gt_9}{
Numeric (0 or 1). E/e' ratio > 9 on echocardiogram. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{H2FPEF_Score}{The calculated score (Range 0-9).}
\item{HFpEF_Probability}{Estimated probability of HFpEF diagnosis.}
}
\references{
Reddy YNV, Carter RE, Obokata M, et al. A Simple, Evidence-Based Scoring System for Patients With Unexplained Dyspnea. Circulation. 2018;138(8):861-870. doi:10.1161/CIRCULATIONAHA.118.034613
}
\examples{

# Example 1: High Probability
# BMI 35 (+2), 3 HTN meds (+1), AFib (+3), Age 70 (+1), E/e' 12 (+1), PASP 40 (+1)
# Score = 9
h2fpef_score(35, 3, 1, 1, 1, 1)

# Example 2: Low Probability
# BMI 25 (0), 0 HTN meds (0), No AFib (0), Age 40 (0), E/e' 8 (0), PASP 25 (0)
# Score = 0
h2fpef_score(25, 0, 0, 0, 0, 0)
}
