\name{haps_score}
\alias{haps_score}
\title{
Harmless Acute Pancreatitis Score (HAPS)
}
\description{
Calculates the Harmless Acute Pancreatitis Score (HAPS). This tool identifies patients with acute pancreatitis who are likely to have a non-severe clinical course (defined as no necrosis and no organ failure). Identification requires the absence of rebound tenderness, normal hematocrit levels, and normal serum creatinine.
}
\usage{
haps_score(rebound_tenderness, hematocrit, creatinine, sex,
           creatinine_units = "mg/dL")
}
\arguments{
  \item{rebound_tenderness}{
Numeric (0 or 1). Presence of rebound tenderness and/or guarding. (1 = Yes, 0 = No).
}
  \item{hematocrit}{
Numeric. Hematocrit percentage. (Normal considered <= 43.0 for men, <= 39.6 for women).
}
  \item{creatinine}{
Numeric. Serum creatinine level. (Normal considered < 2.0 mg/dL).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Used for Hematocrit threshold.
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "micromol/L".
}
}
\value{
A list containing:
\item{HAPS_Result}{Interpretation: "Harmless Acute Pancreatitis Likely" (if all criteria are normal) or "Not Classified as Harmless".}
\item{Probability_Harmless_Course}{Positive Predictive Value for a harmless course (~98\% if HAPS criteria met).}
\item{Criteria_Failed}{List of specific parameters that were abnormal, preventing the "Harmless" classification.}
}
\references{
Lankisch PG, Weber-Dany B, Hebel K, Maisonneuve P, Lowenfels AB. The harmless acute pancreatitis score: a clinical algorithm for rapid initial stratification of nonsevere disease. Clin Gastroenterol Hepatol. 2009;7(6):702-705. doi:10.1016/j.cgh.2009.02.020
}
\examples{

# Example 1: Harmless Course Likely
# No rebound, Hct 40 (Male), Cr 1.0
haps_score(0, 40, 1.0, "male")

# Example 2: Risk of Severe Course
# No rebound, but Hct 45 (Male -> Abnormal), Cr 1.0
haps_score(0, 45, 1.0, "male")
}
