\name{horowitz_index_pf_ratio}
\alias{horowitz_index_pf_ratio}
\title{
Horowitz Index (P/F Ratio) for Lung Function
}
\description{
Calculates the Horowitz Index, also known as the P/F ratio (PaO2/FiO2). This index is a widely used clinical indicator of lung function and is central to the Berlin Definition of Acute Respiratory Distress Syndrome (ARDS). It assesses the degree of hypoxemia.
}
\usage{
horowitz_index_pf_ratio(pao2_mmhg, fio2_percent)
}
\arguments{
  \item{pao2_mmhg}{
Numeric. Arterial partial pressure of oxygen in mmHg.
}
  \item{fio2_percent}{
Numeric. Fraction of inspired oxygen expressed as a percentage (e.g., 21 for room air, 40 for 40\%).
}
}
\value{
A list containing:
\item{Horowitz_Index}{The calculated P/F ratio.}
\item{ARDS_Severity}{Classification based on Berlin criteria (Normal >300, Mild 200-300, Moderate 100-200, Severe <=100).}
}
\references{
Horovitz JH, Carrico CJ, Shires GT. Pulmonary response to major injury. Arch Surg. 1974;108(3):349-355.
The ARDS Definition Task Force. Acute Respiratory Distress Syndrome: The Berlin Definition. JAMA. 2012;307(23):2526-2533.
}
\examples{

# Example 1: Severe ARDS
# PaO2 60 mmHg on 80% FiO2
# Ratio = 60 / 0.8 = 75
horowitz_index_pf_ratio(60, 80)

# Example 2: Normal Lung Function
# PaO2 95 mmHg on Room Air (21%)
# Ratio = 95 / 0.21 = 452
horowitz_index_pf_ratio(95, 21)
}
