\name{iota_simple_rules_risk}
\alias{iota_simple_rules_risk}
\title{
IOTA Simple Rules Risk Assessment for Ovarian Tumors
}
\description{
Calculates the estimated risk of malignancy for adnexal masses using the International Ovarian Tumor Analysis (IOTA) Simple Rules Risk (SRR) model. This model applies a logistic regression to the 10 standard IOTA Simple Rules features to provide a specific probability of malignancy, even when the standard rules classification is "Inconclusive".
}
\usage{
iota_simple_rules_risk(b1_unilocular, b2_solid_lt_7mm, b3_acoustic_shadows,
                       b4_smooth_multi_lt_100mm, b5_no_blood_flow,
                       m1_irregular_solid, m2_ascites, m3_four_papillary_structures,
                       m4_irregular_multi_gt_100mm, m5_strong_blood_flow)
}
\arguments{
  \item{b1_unilocular}{
Numeric (0 or 1). B1: Unilocular cyst. (1 = Yes).
}
  \item{b2_solid_lt_7mm}{
Numeric (0 or 1). B2: Presence of solid components with largest diameter < 7 mm. (1 = Yes).
}
  \item{b3_acoustic_shadows}{
Numeric (0 or 1). B3: Presence of acoustic shadows. (1 = Yes).
}
  \item{b4_smooth_multi_lt_100mm}{
Numeric (0 or 1). B4: Smooth multilocular tumor with largest diameter < 100 mm. (1 = Yes).
}
  \item{b5_no_blood_flow}{
Numeric (0 or 1). B5: No blood flow (Color score 1). (1 = Yes).
}
  \item{m1_irregular_solid}{
Numeric (0 or 1). M1: Irregular solid tumor. (1 = Yes).
}
  \item{m2_ascites}{
Numeric (0 or 1). M2: Presence of ascites. (1 = Yes).
}
  \item{m3_four_papillary_structures}{
Numeric (0 or 1). M3: At least four papillary structures. (1 = Yes).
}
  \item{m4_irregular_multi_gt_100mm}{
Numeric (0 or 1). M4: Irregular multilocular solid tumor with largest diameter >= 100 mm. (1 = Yes).
}
  \item{m5_strong_blood_flow}{
Numeric (0 or 1). M5: Very strong blood flow (Color score 4). (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_of_Malignancy_Percent}{The estimated percentage probability that the tumor is malignant.}
\item{Original_Classification}{The outcome based on the original non-risk-calculating Simple Rules (Benign, Malignant, or Inconclusive).}
}
\references{
Timmerman D, Van Calster B, Testa A, et al. Predicting the risk of malignancy in adnexal masses based on the Simple Rules from the International Ovarian Tumor Analysis group. Am J Obstet Gynecol. 2016;214(4):424-437. doi:10.1016/j.ajog.2016.01.007
}
\examples{

# Example 1: Benign (Low Risk)
# Unilocular (B1), No flow (B5), No M features
iota_simple_rules_risk(1, 0, 0, 0, 1, 0, 0, 0, 0, 0)

# Example 2: Malignant (High Risk)
# Ascites (M2), Strong flow (M5), No B features
iota_simple_rules_risk(0, 0, 0, 0, 0, 0, 1, 0, 0, 1)

# Example 3: Inconclusive (Mixed features)
# Smooth Multi <100 (B4), but Strong flow (M5)
iota_simple_rules_risk(0, 0, 0, 1, 0, 0, 0, 0, 0, 1)
}
