\name{isth_scc_bleeding_tool}
\alias{isth_scc_bleeding_tool}
\title{
ISTH-SCC Bleeding Assessment Tool (BAT)
}
\description{
Calculates the ISTH-SCC BAT score to screen for inherited bleeding disorders (e.g., von Willebrand disease, platelet disorders). The tool evaluates bleeding severity across 13 domains, assigning points (0-4) based on the level of medical intervention required.
}
\usage{
isth_scc_bleeding_tool(epistaxis_score, cutaneous_score, minor_wounds_score,
                       oral_cavity_score, gi_bleeding_score, pulmonary_score,
                       hematuria_score, menorrhagia_score, postpartum_hemorrhage_score,
                       surgery_bleeding_score, dental_bleeding_score,
                       cns_bleeding_score, other_bleeding_score, age, sex)
}
\arguments{
  \item{epistaxis_score}{Numeric (0-4). Score for nosebleeds.}
  \item{cutaneous_score}{Numeric (0-4). Score for bruising/petechiae.}
  \item{minor_wounds_score}{Numeric (0-4). Score for bleeding from minor cuts.}
  \item{oral_cavity_score}{Numeric (0-4). Score for gum bleeding/oral cavity.}
  \item{gi_bleeding_score}{Numeric (0-4). Score for gastrointestinal bleeding.}
  \item{pulmonary_score}{Numeric (0-4). Score for hemoptysis.}
  \item{hematuria_score}{Numeric (0-4). Score for blood in urine.}
  \item{menorrhagia_score}{Numeric (0-4). Score for heavy menstrual bleeding.}
  \item{postpartum_hemorrhage_score}{Numeric (0-4). Score for bleeding after delivery.}
  \item{surgery_bleeding_score}{Numeric (0-4). Score for bleeding during/after surgery.}
  \item{dental_bleeding_score}{Numeric (0-4). Score for bleeding after dental procedures.}
  \item{cns_bleeding_score}{Numeric (0-4). Score for intracranial/CNS bleeding (usually 0 or 4).}
  \item{other_bleeding_score}{Numeric (0-4). Score for other types (e.g., ovulation, muscle/joint).}
  \item{age}{Numeric. Patient age in years.}
  \item{sex}{String. "Male" or "Female".}
}
\details{
\strong{General Scoring Key:}
0 = No symptoms
1 = Reported, no medical attention
2 = Medical attention (consultation)
3 = Surgical intervention, packing, cauterization, or antifibrinolytics
4 = Blood transfusion, replacement therapy, or desmopressin

\strong{Abnormal Cutoffs:}
Children (<18y): >= 3
Adult Males: >= 4
Adult Females: >= 6
}
\value{
A list containing:
\item{ISTH_BAT_Score}{The calculated total score.}
\item{Interpretation}{Screening result based on age/sex-specific cutoffs.}
\item{Cutoff_Applied}{The threshold used for the interpretation.}
}
\references{
Rodeghiero F, Tosetto A, Abshire T, et al. ISTH/SSC bleeding assessment tool: a standardized questionnaire and a proposal for a new bleeding score for inherited bleeding disorders. J Thromb Haemost. 2010;8(9):2063-2065. doi:10.1111/j.1538-7836.2010.03975.x
}
\examples{

# Example 1: Abnormal (Adult Female)
# Menorrhagia (3 - intervention), Epistaxis (2 - consult), Cutaneous (2 - consult)
# Score = 7 (Cutoff 6)
isth_scc_bleeding_tool(2, 2, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 30, "female")

# Example 2: Normal (Adult Male)
# Cutaneous (1), Minor wounds (1)
# Score = 2 (Cutoff 4)
isth_scc_bleeding_tool(0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, "male")
}
