\name{mcdonald_ms_criteria_2010}
\alias{mcdonald_ms_criteria_2010}
\title{
McDonald Criteria for Multiple Sclerosis (2010 Revision)
}
\description{
Evaluates the 2010 Revised McDonald Criteria for the diagnosis of Multiple Sclerosis (MS). These criteria allow for the diagnosis of MS in patients with a first clinical demyelinating event (Clinically Isolated Syndrome) using MRI evidence to substitute for clinical dissemination in space (DIS) and/or time (DIT).
}
\usage{
mcdonald_ms_criteria_2010(clinical_attacks, clinical_lesions, dis_demonstrated,
                          dit_demonstrated)
}
\arguments{
  \item{clinical_attacks}{
Numeric. Number of clinical attacks (relapses). (1 or >=2).
}
  \item{clinical_lesions}{
Numeric. Number of lesions with objective clinical evidence. (1 or >=2).
}
  \item{dis_demonstrated}{
Numeric (0 or 1). Dissemination in Space (DIS) demonstrated by MRI (>=1 T2 lesion in >=2 of 4 MS-typical regions: periventricular, juxtacortical, infratentorial, or spinal cord). (1 = Yes).
}
  \item{dit_demonstrated}{
Numeric (0 or 1). Dissemination in Time (DIT) demonstrated by MRI (e.g., simultaneous asymptomatic gadolinium-enhancing and non-enhancing lesions, or a new T2/enhancing lesion on follow-up). (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Multiple Sclerosis (MS)" or "Criteria Not Met / Possible CIS".}
\item{Missing_Criteria}{List of specific criteria (DIS or DIT) required to confirm the diagnosis.}
}
\references{
Polman CH, Reingold SC, Banwell B, et al. Diagnostic criteria for multiple sclerosis: 2010 revisions to the McDonald criteria. Ann Neurol. 2011;69(2):292-302. doi:10.1002/ana.22366
}
\examples{

# Example 1: Diagnosis Met (2 attacks, 1 lesion, DIS present)
mcdonald_ms_criteria_2010(2, 1, 1, 0)

# Example 2: CIS (1 attack, 1 lesion, DIS present, No DIT)
mcdonald_ms_criteria_2010(1, 1, 1, 0)
}
