\name{nexus_c_spine_criteria}
\alias{nexus_c_spine_criteria}
\title{
NEXUS Criteria for C-Spine Imaging
}
\description{
Calculates the NEXUS (National Emergency X-Radiography Utilization Study) criteria result to determine the need for cervical spine imaging in blunt trauma patients. If all five criteria are absent, the patient is considered low risk and can be cleared clinically without imaging.
}
\usage{
nexus_c_spine_criteria(focal_neurologic_deficit, midline_spinal_tenderness,
                       altered_level_of_consciousness, intoxication,
                       distracting_injury)
}
\arguments{
  \item{focal_neurologic_deficit}{
Numeric (0 or 1). Presence of focal neurologic deficit. (1 = Yes).
}
  \item{midline_spinal_tenderness}{
Numeric (0 or 1). Presence of posterior midline cervical spinal tenderness. (1 = Yes).
}
  \item{altered_level_of_consciousness}{
Numeric (0 or 1). Presence of an altered level of consciousness (GCS < 15, disorientation, etc.). (1 = Yes).
}
  \item{intoxication}{
Numeric (0 or 1). Is there evidence of intoxication? (1 = Yes).
}
  \item{distracting_injury}{
Numeric (0 or 1). Is there a painful distracting injury? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the need for C-spine imaging ("Indicated" or "Not Indicated").}
\item{Inputs}{A summary of the criteria evaluated.}
}
\references{
Hoffman JR, Mower WR, Wolfson AB, et al. Validity of a set of clinical criteria to rule out injury to the cervical spine in patients with blunt trauma. N Engl J Med. 2000;343(2):94-99. doi:10.1056/NEJM200007133430203
}
\examples{

# Example 1: Low Risk (Cleared)
# No deficits, no tenderness, alert, sober, no distracting injury
nexus_c_spine_criteria(0, 0, 0, 0, 0)

# Example 2: Imaging Indicated (Distracting Injury)
# Distracting injury present
nexus_c_spine_criteria(0, 0, 0, 0, 1)
}
