\name{nirudak_score}
\alias{nirudak_score}
\title{
NIRUDAK Score for Dehydration in Children
}
\description{
Calculates the NIRUDAK (Novel Innovative Research Understanding Dehydration) Score, a clinical prediction rule to assess the severity of dehydration in children. The score uses a combination of six easily assessable clinical signs to predict significant dehydration (e.g., \eqn{\ge} 5\% weight loss).
}
\usage{
nirudak_score(crt_seconds, tachycardia_present, lethargy_coma, dry_mucous_membranes,
              cold_mottled_extremities, sunken_eyes)
}
\arguments{
  \item{crt_seconds}{
Numeric. Capillary Refill Time (CRT) in seconds. (\eqn{\ge} 3 seconds adds 2 points).
}
  \item{tachycardia_present}{
Numeric (0 or 1). Presence of tachycardia (Heart Rate greater than the 90th percentile for age). (1 = Yes, +2 points).
}
  \item{lethargy_coma}{
Numeric (0 or 1). Altered mental status (lethargy or comatose). (1 = Yes, +2 points).
}
  \item{dry_mucous_membranes}{
Numeric (0 or 1). Dry mucous membranes (DMM) present. (1 = Yes, +1 point).
}
  \item{cold_mottled_extremities}{
Numeric (0 or 1). Presence of cold or mottled extremities. (1 = Yes, +2 points).
}
  \item{sunken_eyes}{
Numeric (0 or 1). Sunken eyes present. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{NIRUDAK_Score}{The calculated total score (Range 0-10).}
\item{Risk_Level}{Risk stratification (Low < 3, Moderate 3-5, High \eqn{\ge} 6).}
}
\references{
Jackson MC, et al. A clinical prediction rule for significant dehydration in children: The NIRUDAK score. Lancet. 2018;391(10116):159-166.
}
\examples{

# Example 1: High Risk (Severe Dehydration Likely)
# CRT 4s (+2), Tachycardia (+2), Cold Extremities (+2)
# Score = 6
nirudak_score(4, 1, 0, 0, 1, 0)

# Example 2: Low Risk
# CRT 2s, No tachycardia, Dry Mucous Membranes (+1)
# Score = 1
nirudak_score(2, 0, 0, 1, 0, 0)
}
