\name{orbit_bleeding_risk_score}
\alias{orbit_bleeding_risk_score}
\title{
ORBIT Bleeding Risk Score for Atrial Fibrillation
}
\description{
Calculates the ORBIT Bleeding Risk Score to predict major bleeding in patients with atrial fibrillation on oral anticoagulation. The score uses five clinical variables: Older age, Reduced hemoglobin/hematocrit/anemia, Bleeding history, Insufficient kidney function, and Treatment with antiplatelet agents.
}
\usage{
orbit_bleeding_risk_score(age_gt_74, reduced_hemoglobin_or_hct_anemia,
                          bleeding_history, insufficient_kidney_function,
                          treatment_with_antiplatelet)
}
\arguments{
  \item{age_gt_74}{
Numeric (0 or 1). Older Age (>74 years). (1 = Yes, +1 point).
}
  \item{reduced_hemoglobin_or_hct_anemia}{
Numeric (0 or 1). Reduced hemoglobin (<13 mg/dL for men, <12 mg/dL for women) or hematocrit (<40\% for men, <36\% for women) or history of anemia. (1 = Yes, +2 points).
}
  \item{bleeding_history}{
Numeric (0 or 1). Bleeding History (GI bleed, intracranial hemorrhage, or hemorrhagic stroke). (1 = Yes, +2 points).
}
  \item{insufficient_kidney_function}{
Numeric (0 or 1). Insufficient kidney function (eGFR <60 mg/dL/1.73 m^2). (1 = Yes, +1 point).
}
  \item{treatment_with_antiplatelet}{
Numeric (0 or 1). Treatment with antiplatelet agents. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{ORBIT_Score}{The calculated risk score (Range 0-7).}
\item{Risk_Group}{Classification (Low: 0-2, Medium: 3, High: 4-7).}
\item{Bleeding_Risk}{Estimated major bleeding rate per 100 patient-years.}
}
\references{
O'Brien EC, Simon DN, Thomas LE, et al. The ORBIT bleeding score: a simple bedside score to assess bleeding risk in atrial fibrillation. Eur Heart J. 2015;36(46):3258-3264. doi:10.1093/eurheartj/ehv476
}
\examples{

# Example 1: High Risk
# Anemia (+2), Bleeding Hx (+2), Antiplatelet (+1)
# Score = 5
orbit_bleeding_risk_score(0, 1, 1, 0, 1)

# Example 2: Low Risk
# Age 70 (0), No other risk factors
# Score = 0
orbit_bleeding_risk_score(0, 0, 0, 0, 0)
}
