\name{pancreatic_fistula_risk_score}
\alias{pancreatic_fistula_risk_score}
\title{
Pancreatic Fistula Risk Score (PFRS)
}
\description{
Calculates the Pancreatic Fistula Risk Score (based on Callery et al., 2013) to predict the development of a clinically relevant postoperative pancreatic fistula (POPF) after pancreatoduodenectomy. The score utilizes intraoperative variables: gland texture, pathology, pancreatic duct diameter, and estimated blood loss.
}
\usage{
pancreatic_fistula_risk_score(gland_texture_soft,
                              pathology_is_adeno_or_pancreatitis,
                              duct_diameter_mm, blood_loss_ml)
}
\arguments{
  \item{gland_texture_soft}{
Numeric (0 or 1). Is the pancreatic gland texture soft? (1 = Yes, Soft [+2 pts]; 0 = No, Hard [0 pts]).
}
  \item{pathology_is_adeno_or_pancreatitis}{
Numeric (0 or 1). Is the pathology Pancreatic Adenocarcinoma or Chronic Pancreatitis? (1 = Yes [0 pts]; 0 = No [Other pathology like neuroendocrine, cystic, duodenal, ampullary adds +1 pt]).
}
  \item{duct_diameter_mm}{
Numeric. Diameter of the main pancreatic duct in millimeters.
>= 5 mm: 0 pts.
4 mm: 1 pt.
3 mm: 2 pts.
2 mm: 3 pts.
<= 1 mm: 4 pts.
}
  \item{blood_loss_ml}{
Numeric. Intraoperative blood loss in milliliters.
<= 400 ml: 0 pts.
401-700 ml: 1 pt.
701-1000 ml: 2 pts.
> 1000 ml: 3 pts.
}
}
\value{
A list containing:
\item{Fistula_Risk_Score}{The calculated total score (Range 0-10).}
\item{Risk_Category}{Classification (Negligible, Low, Intermediate, High).}
\item{Est_Pancreatic_Fistula_Risk}{Estimated percentage risk of developing a Grade B or C fistula.}
}
\references{
Callery MP, Pratt WB, Kent TS, et al. A prospectively validated clinical risk score accurately predicts pancreatic fistula after pancreatoduodenectomy. J Am Coll Surg. 2013;216(1):1-14. doi:10.1016/j.jamcollsurg.2012.09.002
}
\examples{
pancreatic_fistula_risk_score(
  gland_texture_soft = 1,
  pathology_is_adeno_or_pancreatitis = 0,
  duct_diameter_mm = 2,
  blood_loss_ml = 200
)

pancreatic_fistula_risk_score(
  gland_texture_soft = 0,
  pathology_is_adeno_or_pancreatitis = 1,
  duct_diameter_mm = 6,
  blood_loss_ml = 500
)
}
