\name{pc_ptsd_5_screen}
\alias{pc_ptsd_5_screen}
\title{
Primary Care PTSD Screen for DSM-5 (PC-PTSD-5)
}
\description{
Calculates the PC-PTSD-5 score, a 5-item screening tool designed for primary care settings to identify patients with probable PTSD. The tool first establishes exposure to a traumatic event, followed by 5 yes/no questions addressing core PTSD symptom clusters (re-experiencing, avoidance, hyperarousal, numbing, and guilt/blame).
}
\usage{
pc_ptsd_5_screen(traumatic_event_exposure, nightmares_intrusive_thoughts,
                 avoidance, hyperarousal_startle, emotional_numbness, guilt_blame)
}
\arguments{
  \item{traumatic_event_exposure}{
Numeric (0 or 1). Has the patient been exposed to a traumatic event? (1 = Yes). This is a prerequisite for the remaining questions.
}
  \item{nightmares_intrusive_thoughts}{
Numeric (0 or 1). In the past month, have you had nightmares about the event or thought about it when you did not want to? (1 = Yes).
}
  \item{avoidance}{
Numeric (0 or 1). In the past month, have you tried hard not to think about the event or went out of your way to avoid situations that reminded you of it? (1 = Yes).
}
  \item{hyperarousal_startle}{
Numeric (0 or 1). In the past month, have you been constantly on guard, watchful, or easily startled? (1 = Yes).
}
  \item{emotional_numbness}{
Numeric (0 or 1). In the past month, have you felt numb or detached from people, activities, or your surroundings? (1 = Yes).
}
  \item{guilt_blame}{
Numeric (0 or 1). In the past month, have you felt guilty or unable to stop blaming yourself or others for the event or any problems the event may have caused? (1 = Yes).
}
}
\value{
A list containing:
\item{PC_PTSD_5_Score}{The calculated total score (Range 0-5).}
\item{Screening_Result}{"Positive Screen" (Score >= 3) or "Negative Screen".}
\item{Recommendation}{Guidance for follow-up.}
}
\references{
Prins A, Bovin MJ, Smolenski DJ, et al. The Primary Care PTSD Screen for DSM-5 (PC-PTSD-5): Development and Evaluation Within a Veteran Primary Care Sample. J Gen Intern Med. 2016;31(10):1206-1211. doi:10.1007/s11606-016-3703-5
}
\examples{

# Example 1: Positive Screen
# Trauma exposed (1), Nightmares (1), Avoidance (1), Startle (1), Numbness (0), Guilt (0)
# Score = 3
pc_ptsd_5_screen(1, 1, 1, 1, 0, 0)

# Example 2: Negative Screen
# Trauma exposed (1), Avoidance (1), No other symptoms
# Score = 1
pc_ptsd_5_screen(1, 0, 1, 0, 0, 0)
}
