\name{pedocs_score}
\alias{pedocs_score}
\title{
PEDOCS Score for Pediatric Emergency Department Overcrowding
}
\description{
Calculates the Pediatric Emergency Department Overcrowding Scale (PEDOCS) score. This tool estimates the severity of overcrowding in a pediatric emergency department at a specific point in time based on the total number of registered patients and the number of patients in the waiting room.
}
\usage{
pedocs_score(total_patients_registered, number_in_waiting_room)
}
\arguments{
  \item{total_patients_registered}{
Numeric. The total number of patients currently registered in the ED (including those in beds and in the waiting room).
}
  \item{number_in_waiting_room}{
Numeric. The number of patients currently in the waiting room.
}
}
\details{
The formula is: \eqn{PEDOCS = 33.3 \times [0.11 + (0.07 \times Waiting Room) + (0.04 \times Total Registered)]}.
Interpretation:
\itemize{
  \item 0-20: Not Busy
  \item 21-60: Busy
  \item 61-100: Extremely Busy
  \item 101-140: Overcrowded
  \item 141-180: Severely Overcrowded
  \item 181-200: Dangerously Overcrowded
}
}
\value{
A list containing:
\item{PEDOCS_Score}{The calculated score (Range 0-200).}
\item{Overcrowding_Status}{Classification of overcrowding severity.}
}
\references{
Weiss SJ, Ernst AA, Nick TG. Development of a novel measure of overcrowding in a pediatric emergency department. Pediatr Emerg Care. 2007;23(9):641-645. doi:10.1097/PEC.0b013e31814a687d
}
\examples{

# Example 1: Not Busy
# 10 registered, 2 waiting
# Score = 33.3 * (0.11 + 0.14 + 0.4) = 33.3 * 0.65 = ~22 (Busy)
pedocs_score(10, 2)

# Example 2: Overcrowded
# 50 registered, 20 waiting
# Score = 33.3 * (0.11 + 1.4 + 2.0) = 33.3 * 3.51 = ~117 (Overcrowded)
pedocs_score(50, 20)
}
