\name{perc_rule_pulmonary_embolism}
\alias{perc_rule_pulmonary_embolism}
\title{
PERC Rule for Pulmonary Embolism
}
\description{
Calculates the Pulmonary Embolism Rule-out Criteria (PERC) to rule out PE in patients with a low pre-test probability. If all 8 criteria are negative, the risk of PE is considered less than 2\%, and no further testing (D-dimer or imaging) is required.
}
\usage{
perc_rule_pulmonary_embolism(age, heart_rate, oxygen_saturation, prior_pe_dvt,
                             recent_trauma_surgery, hemoptysis, exogenous_estrogen,
                             unilateral_leg_swelling)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 50 is a positive finding).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 100 is a positive finding).
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation percentage (SaO2). (< 95\% is a positive finding).
}
  \item{prior_pe_dvt}{
Numeric (0 or 1). Prior history of DVT or PE. (1 = Yes).
}
  \item{recent_trauma_surgery}{
Numeric (0 or 1). Recent trauma or surgery (within 4 weeks) requiring hospitalization. (1 = Yes).
}
  \item{hemoptysis}{
Numeric (0 or 1). Presence of hemoptysis. (1 = Yes).
}
  \item{exogenous_estrogen}{
Numeric (0 or 1). Use of exogenous estrogen (OCP, HRT). (1 = Yes).
}
  \item{unilateral_leg_swelling}{
Numeric (0 or 1). Unilateral leg swelling suggestive of DVT. (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{"PERC Rule Negative" or "PERC Rule Not Met".}
\item{Recommendation}{Clinical guidance based on the result.}
\item{Positive_Criteria}{A list of criteria that prevented the rule from being negative.}
}
\references{
Kline JA, Mitchell AM, Kabrhel C, et al. Clinical criteria to prevent unnecessary diagnostic testing in emergency department patients with suspected pulmonary embolism. J Thromb Haemost. 2004;2(8):1247-1255. doi:10.1111/j.1538-7836.2004.00790.x
}
\examples{

# Example 1: PERC Negative
# 30yo, HR 80, SaO2 98%, No other factors
perc_rule_pulmonary_embolism(30, 80, 98, 0, 0, 0, 0, 0)

# Example 2: PERC Not Met
# 30yo, HR 80, SaO2 98%, Taking OCP (Estrogen)
perc_rule_pulmonary_embolism(30, 80, 98, 0, 0, 0, 1, 0)
}
