\name{regiscar_dress_score}
\alias{regiscar_dress_score}
\title{
RegiSCAR Score for DRESS Syndrome
}
\description{
Calculates the RegiSCAR score to diagnose Drug Reaction with Eosinophilia and Systemic Symptoms (DRESS). The score evaluates clinical features including fever, lymphadenopathy, hematologic abnormalities, skin involvement, organ involvement, and exclusion of other causes.
}
\usage{
regiscar_dress_score(fever_gt_385, lymphadenopathy, eosinophil_count,
                     atypical_lymphocytes, skin_extent_gt_50,
                     skin_suggestive_features, organ_involvement_count,
                     other_causes_excluded, resolution_gt_15_days = 1)
}
\arguments{
  \item{fever_gt_385}{
Numeric (0 or 1). Fever > 38.5 degrees Celsius. (1 = Yes, +1 point).
}
  \item{lymphadenopathy}{
Numeric (0 or 1). Enlarged lymph nodes in >= 2 sites (> 1 cm). (1 = Yes, +1 point).
}
  \item{eosinophil_count}{
Numeric. Absolute Eosinophil Count (cells/uL). (>= 700: +1, >= 1500: +2).
}
  \item{atypical_lymphocytes}{
Numeric (0 or 1). Presence of atypical lymphocytes. (1 = Yes, +1 point).
}
  \item{skin_extent_gt_50}{
Numeric (0 or 1). Skin rash extent > 50\% body surface area. (1 = Yes, +1 point).
}
  \item{skin_suggestive_features}{
Numeric (0 or 1). Presence of at least 2 suggestive skin features (e.g., infiltration, purpura, scaling, facial edema). (1 = Yes, +1 point).
}
  \item{organ_involvement_count}{
Numeric. Number of internal organs involved (e.g., liver, kidney, lung). (1 organ: +1, >=2 organs: +2).
}
  \item{other_causes_excluded}{
Numeric (0 or 1). Were other potential causes (e.g., viral infections, ANA, blood culture) excluded? (1 = Yes, +1 point).
}
  \item{resolution_gt_15_days}{
Numeric (0 or 1). Did the reaction last more than 15 days? (1 = Yes, 0 pts; 0 = No, -1 point). Defaults to 1 (Yes) as DRESS is typically persistent.
}
}
\value{
A list containing:
\item{RegiSCAR_Score}{The calculated total score.}
\item{Diagnosis}{Diagnostic classification (No, Possible, Probable, or Definite DRESS).}
}
\references{
Kardaun SH, Sidoroff A, Valeyrie-Allanore L, et al. Variability in the clinical pattern of cutaneous side-effects of drugs with systemic symptoms: does a DRESS syndrome really exist? Br J Dermatol. 2007;156(3):609-611. doi:10.1111/j.1365-2133.2006.07704.x
}
\examples{

# Example 1: Probable DRESS
# Fever(+1), Eos 900(+1), Atypical Lymphs(+1), Rash >50%(+1), No organs(0)
# Score = 4
regiscar_dress_score(1, 0, 900, 1, 1, 0, 0, 0, 1)

# Example 2: Definite DRESS
# Fever(+1), Nodes(+1), Eos 2000(+2), Rash Feat(+1), Liver/Kidney(+2)
# Score = 7
regiscar_dress_score(1, 1, 2000, 0, 0, 1, 2, 0, 1)
}
