\name{revised_cardiac_risk_index}
\alias{revised_cardiac_risk_index}
\title{
Revised Cardiac Risk Index (RCRI) for Pre-Operative Risk
}
\description{
Calculates the Revised Cardiac Risk Index (Lee Index) to estimate the risk of major cardiac complications (myocardial infarction, pulmonary edema, ventricular fibrillation, cardiac arrest, complete heart block) after noncardiac surgery.
}
\usage{
revised_cardiac_risk_index(high_risk_surgery, ischemic_heart_disease,
                           congestive_heart_failure, cerebrovascular_disease,
                           insulin_treatment, preop_creatinine_gt_2)
}
\arguments{
  \item{high_risk_surgery}{
Numeric (0 or 1). Intraperitoneal, intrathoracic, or suprainguinal vascular surgery. (1 = Yes).
}
  \item{ischemic_heart_disease}{
Numeric (0 or 1). History of MI, positive exercise test, current chest pain due to ischemia, nitrate use, or pathological Q waves. (1 = Yes).
}
  \item{congestive_heart_failure}{
Numeric (0 or 1). History of CHF, pulmonary edema, or paroxysmal nocturnal dyspnea. (1 = Yes).
}
  \item{cerebrovascular_disease}{
Numeric (0 or 1). Prior TIA or stroke. (1 = Yes).
}
  \item{insulin_treatment}{
Numeric (0 or 1). Pre-operative treatment with insulin. (1 = Yes).
}
  \item{preop_creatinine_gt_2}{
Numeric (0 or 1). Pre-operative serum creatinine > 2.0 mg/dL (> 176.8 micromol/L). (1 = Yes).
}
}
\value{
A list containing:
\item{RCRI_Score}{The calculated score (Range 0-6).}
\item{Risk_Class}{The Lee Risk Class (I, II, III, or IV).}
\item{Est_Major_Cardiac_Event_Risk}{Estimated probability of a major cardiac event based on the original validation cohort.}
}
\references{
Lee TH, Marcantonio ER, Mangione CM, et al. Derivation and prospective validation of a simple index for prediction of cardiac risk of major noncardiac surgery. Circulation. 1999;100(10):1043-1049. doi:10.1161/01.cir.100.10.1043
}
\examples{

# Example 1: Low Risk
# No risk factors
# Score = 0
revised_cardiac_risk_index(0, 0, 0, 0, 0, 0)

# Example 2: High Risk
# Vascular surgery (+1), Insulin (+1), History of MI (+1)
# Score = 3
revised_cardiac_risk_index(1, 1, 0, 0, 1, 0)
}
