\name{richmond_agitation_sedation_scale}
\alias{richmond_agitation_sedation_scale}
\title{
Richmond Agitation-Sedation Scale (RASS)
}
\description{
Calculates the RASS score, a validated tool to assess the level of sedation and agitation in hospitalized patients. It uses a logic-based approach starting with observation of behavior, followed by response to voice, and finally response to physical stimulation.
}
\usage{
richmond_agitation_sedation_scale(observed_behavior,
                                  voice_stimulation = "not_applicable",
                                  physical_stimulation = "not_applicable")
}
\arguments{
  \item{observed_behavior}{
String. The patient's spontaneous behavior.
Options:
"combative" (+4)
"very_agitated" (+3)
"agitated" (+2)
"restless" (+1)
"alert_and_calm" (0)
"not_alert" (Proceed to voice stimulation)
}
  \item{voice_stimulation}{
String. Response to verbal stimulation (e.g., calling name, asking to open eyes). Required if \code{observed_behavior} is "not_alert".
Options:
"eye_contact_gt_10s" (-1)
"eye_contact_lt_10s" (-2)
"movement_no_eye_contact" (-3)
"no_response" (Proceed to physical stimulation)
"not_applicable" (Default)
}
  \item{physical_stimulation}{
String. Response to physical stimulation (e.g., shoulder shake, sternal rub). Required if no response to voice.
Options:
"movement_or_eye_opening" (-4)
"no_response" (-5)
"not_applicable" (Default)
}
}
\value{
A list containing:
\item{RASS_Score}{The calculated score (integer from -5 to +4).}
\item{Term}{The clinical term associated with the score (e.g., "Light Sedation").}
\item{Description}{Detailed description of the patient's state.}
}
\references{
Sessler CN, Gosnell MS, Grap MJ, et al. The Richmond Agitation-Sedation Scale: validity and reliability in adult intensive care unit patients. Am J Respir Crit Care Med. 2002;166(10):1338-1344. doi:10.1164/rccm.2107138
}
\examples{

# Example 1: Agitated Patient
# Patient is fighting the ventilator
richmond_agitation_sedation_scale("agitated")

# Example 2: Light Sedation
# Patient is not alert, makes eye contact for < 10 seconds to voice
richmond_agitation_sedation_scale("not_alert", "eye_contact_lt_10s")

# Example 3: Unarousable
# Patient not alert, no response to voice, no response to physical stim
richmond_agitation_sedation_scale("not_alert", "no_response", "no_response")
}
