\name{rome_iv_reflux_hypersensitivity}
\alias{rome_iv_reflux_hypersensitivity}
\title{
Rome IV Diagnostic Criteria for Reflux Hypersensitivity
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Reflux Hypersensitivity**. This disorder is characterized by retrosternal symptoms (heartburn or chest pain) caused by physiological amounts of reflux (non-acid or acid) in patients who are refractory to proton pump inhibitor (PPI) therapy and lack endoscopic evidence of erosive esophagitis.
}
\usage{
rome_iv_reflux_hypersensitivity(retrosternal_symptoms_bothersome, normal_egd,
                                 reflux_excluded, symptoms_refractory_to_ppis,
                                 symptoms_triggered_by_reflux,
                                 symptoms_not_associated_with_major_motility,
                                 symptom_onset_ge_6_months,
                                 symptoms_active_last_3_months)
}
\arguments{
  \item{retrosternal_symptoms_bothersome}{
Numeric (0 or 1). Presence of bothersome retrosternal symptoms (heartburn or chest pain). (1 = Yes).
}
  \item{normal_egd}{
Numeric (0 or 1). Normal Esophagogastroduodenoscopy (EGD) (i.e., no erosive esophagitis). (1 = Yes).
}
  \item{reflux_excluded}{
Numeric (0 or 1). Absence of pathological reflux (negative symptom association probability or acid exposure time). (1 = Yes).
}
  \item{symptoms_refractory_to_ppis}{
Numeric (0 or 1). Refractory to optimized antisecretory therapy (e.g., maximal PPIs). (1 = Yes).
}
  \item{symptoms_triggered_by_reflux}{
Numeric (0 or 1). Symptoms are triggered by reflux events (positive symptom association probability or symptom index on reflux monitoring). (1 = Yes).
}
  \item{symptoms_not_associated_with_major_motility}{
Numeric (0 or 1). Absence of major esophageal motor disorders (e.g., achalasia, spasm). (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Reflux Hypersensitivity" or "Criteria Not Met".}
}
\references{
Aben-Fawaz H, Kahrilas PJ, Chen J. Esophageal disorders. Gastroenterology. 2016;150:1367-1379. doi:10.1053/j.gastro.2016.02.002
}
\examples{

# Example 1: Diagnosis Met
# All criteria met (bothersome symptoms, normal EGD, triggered by normal reflux,
#PPI refractory, no motility issues, chronic duration)
rome_iv_reflux_hypersensitivity(1, 1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Pathological Reflux Present)
# Reflux monitoring shows excessive acid exposure time (0 for reflux_excluded)
rome_iv_reflux_hypersensitivity(1, 1, 0, 1, 1, 1, 1, 1)
}
