% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regimes.R
\name{detect_regimes}
\alias{detect_regimes}
\title{Regime Detection for Time Series Data}
\usage{
detect_regimes(
  data,
  method = "smart",
  sensitivity = "medium",
  min_change,
  window = 10,
  peak = 2,
  cumulative = 0.6
)
}
\arguments{
\item{data}{[\code{ts}, \code{numeric()}]\cr Univariate time series data.}

\item{method}{[\code{character(1)}]\cr Detection method.
The available options are:
\itemize{
\item \code{"cumulative_peaks"}: Detects cumulative complexity peaks using Z-tests.
\item \code{"changepoint"}: Change point detection (multi-window mean-shift test).
\item \code{"threshold"}: Adaptive quartile-based regime classification.
\item \code{"variance_shift"}: Detects changes in variance patterns.
\item \code{"slope"}: Detects changes in local slope (rolling linear models).
\item \code{"entropy"}: Detects changes in the Shannon entropy of the
complexity series, calculated in rolling windows.
\item \code{"smart"} (default): Combines gradient, peaks, and changepoint methods.
\item \code{"all"}: Applies all individual methods listed above and uses
ensemble voting.
}}

\item{sensitivity}{[\code{character(1)}]\cr Detection sensitivity level.
The available options are: \code{"low"}, \code{"medium"}, \code{"high"}.
The default is \code{"medium"}. This affects thresholds and window sizes within
the detection methods.}

\item{min_change}{[\code{integer(1)}]\cr Minimum number of observations between
changes. If missing (default), the value is determined automatically
(typically 10\% of observations, minimum of 10).}

\item{window}{[\code{integer(1)}]\cr base window size for rolling calculations.
This is further adjusted by \code{sensitivity}. The default is \code{10}.}

\item{peak}{[\code{numeric(1)}]\cr Base z-score threshold for individual peak
detection with the \code{"cumulative_peaks"} method.
Adjusted by \code{sensitivity}. The default is \code{2.0}.}

\item{cumulative}{[\code{numeric(1)}]\cr A value between 0 and 1 that defines
the base proportion threshold for identifying cumulative peak regions.
Adjusted by \code{sensitivity}. The default is \code{0.6}.}
}
\value{
An object of class \code{regimes} which is a \code{tibble} containing
the following columns:

\code{value}: Original time series data.
\code{time}: Original time points.
\code{change}: A \code{logical} vector indicating regime changes.
\code{id}: An \code{integer} regime identifier.
\code{type}: Type of change detected by the method.
\code{magnitude}: Magnitude of the change (method-specific interpretation)
\code{confidence}: Confidence in the detection
(method-specific interpretation, typically between \code{0} and \code{1}, or \code{NA})
\code{stability}: Categorical stability: \code{"Stable"}, \code{"Transitional"}, and
\code{"Unstable"}.
\code{score}: A \code{numeric} stability score between \code{0} and \code{1}.
}
\description{
Detects regime changes in time series data using multiple methods including
cumulative peaks, changepoint detection, variance shifts,
threshold analysis, gradient changes, and entropy analysis.
}
\examples{
set.seed(123)
ts_data <- stats::arima.sim(list(order = c(1, 1, 0), ar = 0.6), n = 200)
regimes <- detect_regimes(
  data = ts_data,
  method = "threshold",
  sensitivity = "medium"
)

}
