% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reshape_data}
\alias{reshape_data}
\title{Reshape Excel Data Based on Custom Markers and Include Custom ID Column}
\usage{
reshape_data(
  input_filepath,
  sheetName = "Results",
  marker = "videoinfo",
  id_col = "ID",
  output_filepath
)
}
\arguments{
\item{input_filepath}{String, the file path of the input Excel file.}

\item{sheetName}{String, the name of the sheet to read from the Excel file. Default is "Results".}

\item{marker}{String, the string that identifies the start of a new section of columns. Default is "videoinfo".}

\item{id_col}{String, the name of the column to use as the ID column. Default is "ID".}

\item{output_filepath}{String, the file path for the output Excel file.}
}
\value{
None, writes the reshaped data to an Excel file specified by output_filepath.
}
\description{
This function takes an Excel file with data in a wide format and transforms it to a long format.
It includes a customizable "ID" column in the first position and repeats it for each slice.
The function identifies sections of columns between markers that start with a user-defined string (default is "videoinfo")
and appends those sections under the first section, aligning by column index.
}
\details{
Relevant if you receive data in wide-format but cannot use built-in functionality due to naming (e.g., in LimeSurvey)
}
\examples{
\donttest{
if (requireNamespace(c("write_xlsx", "readxl"), quietly = TRUE)) {
  tmp_in  <- tempfile(fileext = ".xlsx")
  tmp_out <- tempfile(fileext = ".xlsx")

  # Minimal toy input that includes your required pieces:
  # an ID column and something that contains the marker value.
  toy <- data.frame(
    ID = c(1, 1, 2, 2),
    section = c("videoinfo", "videoinfo", "videoinfo", "videoinfo"),
    key = c("fps", "duration_s", "fps", "duration_s"),
    value = c(30, 12.3, 25, 9.8),
    stringsAsFactors = FALSE
  )

  writexl::write_xlsx(toy, tmp_in)

  reshape_data(
    input_filepath = tmp_in,
    marker = "videoinfo",
    id_col = "ID",
    output_filepath = tmp_out
  )

  out <- readxl::read_excel(tmp_out)
  print(out)
}
}

}
