% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-options.R
\name{constructive-global_options}
\alias{constructive-global_options}
\alias{constructive_opts_template}
\alias{constructive_pretty}
\alias{constructive_print_mode}
\title{Global Options}
\description{
Set these options to tweak \{constructive\}'s global behavior, to set them
permanently you can edit your \code{.RProfile1}, e.g. using \code{usethis::edit_r_profile()}.
}
\details{
\itemize{
\item Set \verb{options(constructive_print_mode = <character>)} to change the default
value of the \code{print_mode} argument, of \code{print.constructive}, where \verb{<character>} is a vector
of strings among the following :
\itemize{
\item \code{"console"} : The default behavior, the code is printed in the console
\item \code{"script"} : The code is copied to a new R script
\item \code{"reprex"} : The code is shown in the viewer as a reprex,
the reprex (not only the code!) is also copied to the clipboard.
\item \code{"clipboard"} : The constructed code is copied to the clipboard, if combined
with \code{"reprex"} this takes precedence (the reprex is showed in the viewer,
the code without output is copied to the clipboard)
}
\item Set \verb{options(constructive_opts_template = <list>)} to set default constructive options,
see documentation of the \code{template} arg in \code{?construct}
\item Set \code{options(constructive_pretty = FALSE)} to disable syntax highlighting.
}
\subsection{Relevant options from other packages:}{
\itemize{
\item \code{cli.code_theme} can be used to configure the syntax highlighting theme
used by \{constructive\}; see \code{\link[cli:code_theme_list]{cli::code_theme_list()}} for more information.
}
}
}
