% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_revalue_yield_plus_growth}
\alias{styles_revalue_yield_plus_growth}
\title{Re-evaluate styles under a yield-plus-growth discounting rule}
\usage{
styles_revalue_yield_plus_growth(
  styles,
  config_dir = system.file("extdata", package = "cre.dcf")
)
}
\arguments{
\item{styles}{Character vector of style identifiers, e.g.
\code{c("core", "core_plus", "value_added", "opportunistic")}.}

\item{config_dir}{Directory from which preset YAML files are loaded.
Defaults to the package \code{inst/extdata} folder.}
}
\value{
A tibble with one row per style and the columns:
\itemize{
\item \code{style} (character),
\item \code{irr_equity_y}: leveraged equity IRR under the
\code{"yield_plus_growth"} convention,
\item \code{npv_equity_y}: leveraged equity NPV under the same
convention.
}
}
\description{
This helper re-runs a set of preset styles under a simplified
\code{"yield_plus_growth"} discounting convention, leaving all cash-flow
assumptions unchanged. It is primarily used in vignettes and tests to check
that the qualitative ordering of styles (in terms of equity IRR and NPV) is
robust to the choice of discounting scheme.
}
\details{
For each style, the function:
\enumerate{
\item loads the corresponding YAML preset file;
\item overrides \code{disc_method <- "yield_plus_growth"};
\item sets \code{disc_rate_yield_plus_growth} so that the property yield
equals \code{entry_yield} and the growth component equals
\code{index_rate};
\item calls [\code{\link[=run_case]{run_case()}}] and extracts the leveraged equity IRR and NPV.
}
}
