% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_rules.R
\name{h_next_best_eligible_doses}
\alias{h_next_best_eligible_doses}
\title{Get Eligible Doses from the Dose Grid.}
\usage{
h_next_best_eligible_doses(dose_grid, doselimit, placebo, levels = FALSE)
}
\arguments{
\item{dose_grid}{(\code{numeric})\cr all possible doses.}

\item{doselimit}{(\code{number})\cr the maximum allowed next dose.}

\item{placebo}{(\code{flag})\cr if \code{TRUE} the first dose level in the \code{dose_grid}
is considered as placebo.}

\item{levels}{(\code{flag})\cr if \code{TRUE} the levels of eligible doses are returned,
otherwise, the doses (default).}
}
\value{
A numeric vector with eligible doses or eligible dose levels if \code{levels}
flag is \code{TRUE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function that gets the eligible doses from the dose grid.
The eligible doses are the doses which do not exceed a given
\code{doselimit}. For placebo design, if safety allows (i.e. if there is at least
one non-placebo dose which does not exceed the dose limit), the placebo dose
is then excluded from the eligible doses.
}
\examples{
dose_grid <- c(0.001, seq(25, 200, 25))
h_next_best_eligible_doses(dose_grid, 79, TRUE)
h_next_best_eligible_doses(dose_grid, 24, TRUE)
}
