% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs-batch.R
\name{get_single_sample_records_by_medium_batch}
\alias{get_single_sample_records_by_medium_batch}
\title{Get Single Sample Records by medium via batch}
\usage{
get_single_sample_records_by_medium_batch(
  Medium = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = "https://comptox.epa.gov/ctx-api/exposure",
  verbose = FALSE
)
}
\arguments{
\item{Medium}{The MMDB medium of exposure}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logicial indicating if some "progress report" should be
given.}
}
\value{
A list of data.frames containing single sample records data for each
input medium.
}
\description{
Get Single Sample Records by medium via batch
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Retrieve single sample records data for 'surface water' and 'soil'
get_single_sample_records_by_medium_batch(Medium = c('surface water', 'soil'))
\dontshow{\}) # examplesIf}
}
