% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.dist.ind.r
\name{gl.dist.ind}
\alias{gl.dist.ind}
\title{Calculates a distance matrix for individuals defined in a genlight object}
\usage{
gl.dist.ind(
  x,
  method = NULL,
  scale = FALSE,
  swap = FALSE,
  type = "dist",
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight [required].}

\item{method}{Specify distance measure [SNP: Euclidean; P/A: Simple].}

\item{scale}{If TRUE, the distances are scaled to fall in the range [0,1] [default TRUE]}

\item{swap}{If TRUE and working with presence-absence data, then presence 
(no disrupting mutation) is scored as 0 and absence (presence of a disrupting 
mutation) is scored as 1 [default FALSE].}

\item{type}{Specify the type of output, dist or matrix [default dist]}

\item{plot.display}{If TRUE, resultant plots are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5","#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
An object of class 'matrix' or dist' giving distances between individuals
}
\description{
Calculates various distances between individuals based on allele
frequencies or presence-absence data
}
\details{
The distance measure for SNP genotypes can be one of:
\itemize{
 \item Euclidean Distance [method = "Euclidean"]
 \item Scaled Euclidean Distance [method='Euclidean", scale=TRUE]
 \item Simple Mismatch Distance [method="Simple"]
 \item Absolute Mismatch Distance [method="Absolute"]
 \item Czekanowski (Manhattan) Distance [method="Manhattan"]
 }
The distance measure for Sequence Tag Presence/Absence data (binary) can be one of:
\itemize{
 \item Euclidean Distance [method = "Euclidean"]
 \item Scaled Euclidean Distance [method='Euclidean", scale=TRUE]
 \item Simple Matching Distance [method="Simple"]
 \item Jaccard Distance [method="Jaccard"]
 \item Bray-Curtis Distance [method="Bray-Curtis"]
 }
Refer to the documentation of functions in
  https://doi.org/10.1101/2023.03.22.533737 for algorithms
  and definitions.
}
\examples{
\donttest{
D <- gl.dist.ind(testset.gl[1:20,], method='manhattan')
D <- gl.dist.ind(testset.gs[1:20,], method='Jaccard',swap=TRUE)
}
D <- gl.dist.ind(testset.gl[1:20,], method='euclidean',scale=TRUE)

}
\seealso{
Other distance: 
\code{\link{gl.dist.pop}()},
\code{\link{gl.fdsim}()},
\code{\link{utils.dist.ind.snp}()}
}
\author{
Author(s): Custodian: Arthur Georges -- Post to #' \url{https://groups.google.com/d/forum/dartr}
}
\concept{distance}
