% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.check.datatype.R
\name{utils.check.datatype}
\alias{utils.check.datatype}
\title{Utility function to check the class of an object passed to a function}
\usage{
utils.check.datatype(
  x,
  accept = c("genlight", "SNP", "SilicoDArT", "dartR"),
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object, dist matrix, data matrix, glPCA, or
fixed difference list (fd) [required].}

\item{accept}{Vector containing the classes of objects that are to be
accepted [default c('genlight','SNP','SilicoDArT'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default NULL, unless specified using gl.set.verbosity].}
}
\value{
datatype, 'SNP' for SNP data, 'SilicoDArT' for P/A data, 'dist' for a
 distance matrix, 'mat' for a data matrix, 'glPCA' for an ordination file, or
  class(x)[1].
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\details{
Most functions require access to a genlight object, dist matrix, data matrix
 or fixed difference list (fd), and this function checks that a genlight
 object or one of the above has been passed, whether the genlight object is a
  SNP dataset or a SilicoDArT object, and reports back if verbosity is >=2.
  
This function checks the class of passed object and sets the datatype to
'SNP', 'SilicoDArT', 'dist', 'mat', or class[1](x) as appropriate.
Note also that this function checks to see if there are individuals or loci
scored as all missing (NA) and if so, issues the user with a warning.
Note: One and only one of gl.check, fd.check, dist.check or mat.check can be
 TRUE.
}
\examples{
datatype <- utils.check.datatype(testset.gl)
datatype <- utils.check.datatype(as.matrix(testset.gl),accept='matrix')
fd <- gl.fixed.diff(testset.gl)
datatype <- utils.check.datatype(fd,accept='fd')
 
}
\seealso{
Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.collapse.matrix}()},
\code{\link{utils.dart2genlight}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.is.fixed}()},
\code{\link{utils.jackknife}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.reset.flags}()},
\code{\link{utils.transpose}()},
\code{\link{utils.vcfr2genlight.polyploid}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{utilities}
