% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_format_conversions.R
\name{int_convert_format}
\alias{int_convert_format}
\title{Convert Interval Data Format}
\usage{
int_convert_format(x, to = "MM", from = NULL, ...)
}
\arguments{
\item{x}{interval data in one of the supported formats}

\item{to}{target format: "MM", "iGAP", "RSDA", "SODAS" (default: "MM")}

\item{from}{source format (optional): "MM", "iGAP", "RSDA", "SODAS". If NULL, will auto-detect.}

\item{...}{additional parameters passed to specific conversion functions}
}
\value{
Interval data in the target format
}
\description{
Automatically detect the format of interval data and convert it to the target format.
}
\details{
This function provides a unified interface for all interval format conversions.
It automatically detects the source format (unless specified) and applies the
appropriate conversion function.

Supported conversions:
\itemize{
  \item RSDA → MM (via \code{RSDA_to_MM})
  \item RSDA → iGAP (via \code{RSDA_to_iGAP})
  \item iGAP → MM (via \code{iGAP_to_MM})
  \item SODAS → MM (via \code{SODAS_to_MM})
  \item SODAS → iGAP (via \code{SODAS_to_iGAP})
  \item MM → iGAP (via \code{MM_to_iGAP})
  \item MM → RSDA (via \code{MM_to_RSDA})
  \item iGAP → RSDA (via \code{iGAP_to_RSDA})
}
}
\examples{
# Auto-detect and convert to MM
data(mushroom.int)
data_mm <- int_convert_format(mushroom.int, to = "MM")

# Explicitly specify source format
data(abalone.iGAP)
data_mm <- int_convert_format(abalone.iGAP, from = "iGAP", to = "MM")

# Convert MM to iGAP
data_igap <- int_convert_format(data_mm, to = "iGAP")

 # Convert multiple datasets to MM
datasets <- list(mushroom.int, abalone.int, car.int)
mm_datasets <- lapply(datasets, int_convert_format, to = "MM")

# Check what conversions are available
int_list_conversions()
}
\seealso{
int_detect_format int_list_conversions RSDA_to_MM iGAP_to_MM MM_to_iGAP MM_to_RSDA iGAP_to_RSDA
}
\author{
Han-Ming Wu
}
