% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_shape.R
\name{interval_shape}
\alias{interval_shape}
\alias{int_skewness}
\alias{int_kurtosis}
\alias{int_symmetry}
\alias{int_tailedness}
\title{Distribution Shape Measures for Interval Data}
\usage{
int_skewness(x, var_name, method = "CM", ...)

int_kurtosis(x, var_name, method = "CM", ...)

int_symmetry(x, var_name, method = "CM", ...)

int_tailedness(x, var_name, method = "CM", ...)
}
\arguments{
\item{x}{interval-valued data with symbolic_tbl class.}

\item{var_name}{the variable name or the column location (multiple variables are allowed).}

\item{method}{methods to calculate statistics: CM (default), VM, QM, SE, FV, EJD, GQ, SPT.}

\item{...}{additional parameters}
}
\value{
A numeric matrix
}
\description{
Functions to compute shape statistics (skewness, kurtosis) for interval-valued data.
}
\details{
These functions measure distribution shape:
\itemize{
  \item \code{int_skewness}: Measure of asymmetry (skewness)
  \item \code{int_kurtosis}: Measure of tail heaviness (kurtosis)
  \item \code{int_symmetry}: Symmetry coefficient
}

Skewness interpretation:
\itemize{
  \item = 0: Symmetric distribution
  \item > 0: Right-skewed (positive skew)
  \item < 0: Left-skewed (negative skew)
}

Kurtosis interpretation (excess kurtosis):
\itemize{
  \item = 0: Normal distribution (mesokurtic)
  \item > 0: Heavy tails (leptokurtic)
  \item < 0: Light tails (platykurtic)
}
}
\examples{
data(mushroom.int)

# Calculate skewness
int_skewness(mushroom.int, var_name = "Pileus.Cap.Width")
int_skewness(mushroom.int, var_name = 2:3, method = c("CM", "EJD"))

# Calculate kurtosis
int_kurtosis(mushroom.int, var_name = c("Stipe.Length", "Stipe.Thickness"))

# Check symmetry
int_symmetry(mushroom.int, var_name = 2:4, method = "CM")
}
\seealso{
int_mean int_var int_skewness int_kurtosis
}
\author{
Han-Ming Wu
}
