% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/charts.R
\name{bar_chart_checkbox}
\alias{bar_chart_checkbox}
\title{Bar chart with frequency and data label with percent.}
\usage{
bar_chart_checkbox(
  data,
  columns,
  sucess = "checked",
  labels = NULL,
  axis_title = "",
  fill = "blue",
  axis_title_axis_size = 22,
  axis_text_axis_size = 22,
  data_label_size = 15,
  sort = TRUE
)
}
\arguments{
\item{data}{dataframe object}

\item{columns}{character vector. Columns to count.}

\item{sucess}{character scalar. Category indicating the sucess. Defaults to "checked".}

\item{labels}{character vector.Label of each category. Defaults to NULL.}

\item{axis_title}{axis y label. Defaults to "".}

\item{fill}{bar color. Character scale with hexidecimal color ou named color. Defaults to "blue".}

\item{axis_title_axis_size}{integer scalar. Size of axis labels. Defaults to 22.}

\item{axis_text_axis_size}{integer scalar. Size of values annotated in axis. Defaults to 22.}

\item{data_label_size}{integer scalar. Size of data labels. Defaults to 15}

\item{sort}{logical scalar. If TRUE, the are ordered using frequency. Defaults to TRUE.}
}
\value{
a ggplot2 object
}
\description{
This function builds a bar chart with ggplot2 for a field with checkbox (user can select 2 or more options). Each option is one separated column.
}
\examples{
df <- data.frame(
 x1 = c("checked", "checked", "unchecked"),
 x2 = c("checked", "unchecked", "checked")
)
bar_chart_checkbox(df, c("x1", "x2"))
}
