% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceMap.R
\docType{class}
\name{ResourceMap-class}
\alias{ResourceMap-class}
\title{ResourceMap provides methods to create, serialize and deserialize an OAI ORE resource map}
\description{
The Open Archives Initiative Object Reuse and Exchange (OAI-ORE) defines standards for the description
and exchange of aggregations of web resources, such as a DataPackage. A Resource Map describes the objects
in a DataPackage and the relationships between these objects.
}
\section{Slots}{

\describe{
\item{\code{relations}}{value of type \code{"data.frame"}, containing RDF triples representing the relationship between package objects}

\item{\code{world}}{a Redland RDF World object}

\item{\code{storage}}{a Redland RDF Storage object}

\item{\code{model}}{a Redland RDF Model object}

\item{\code{id}}{a unique identifier for a ResourceMap instance}
}}

\section{Methods}{

\describe{
 \item{\code{\link[=ResourceMap-initialize]{initialize}}}{: Initialize a ResourceMap object.}
 \item{\code{\link{createFromTriples}}}{: Populate a ResourceMap with RDF relationships from data.frame.}
 \item{\code{\link{getTriples}}}{: Get the RDF relationships stored in the ResourceMap.}
 \item{\code{\link{parseRDF}}}{: Parse an RDF/XML resource map from a file.}
 \item{\code{\link{serializeRDF}}}{: Write the ResourceMap relationships to a file.}
}
}

\examples{
dp <- new("DataPackage")
dp <- insertRelationship(dp, "/Users/smith/scripts/genFields.R",
    "http://www.w3.org/ns/prov#used",
    "https://knb.ecoinformatics.org/knb/d1/mn/v1/object/doi:1234/_030MXTI009R00_20030812.40.1")
relations <- getRelationships(dp)
resMap <- new("ResourceMap")
resMap <- createFromTriples(resMap, relations, getIdentifiers(dp))
\dontrun{
tf <- tempfile(fileext=".rdf")
serializeRDF(resMap, file=tf)
}
}
\seealso{
\code{\link{datapack}}
}
\keyword{resourceMap}
